/*
 * Decompiled with CFR 0.152.
 */
package dyorgio.runtime.out.process;

import dyorgio.runtime.out.process.OutProcessDiedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OutProcessUtils {
    public static final String RUNNING_AS_OUT_PROCESS = "$RunnningAsOutProcess";
    public static final String SHUTDOWN_OUT_PROCESS_REQUESTED = "$ShutdownOutProcessRequested";
    private static final ThreadLocal<CachedBuffer> BUFFER_CACHE = new ThreadLocal(){

        protected Object initialValue() {
            return new CachedBuffer();
        }
    };
    private static boolean IS_MAC;
    private static boolean IS_WINDOWS;
    private static boolean IS_LINUX;
    private static Pattern WINDOWS_DRIVER_LETTER_PATTERN;

    static {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (OS.contains("mac") || OS.contains("darwin")) {
            IS_MAC = true;
        } else if (OS.contains("win")) {
            IS_WINDOWS = true;
            WINDOWS_DRIVER_LETTER_PATTERN = Pattern.compile("\\w:\\\\(.*)");
        } else if (OS.contains("nux")) {
            IS_LINUX = true;
        } else {
            throw new RuntimeException("Unsupported OS:" + OS);
        }
    }

    public static void compatibleInheritIO(String srcIdentifier, final InputStream src, final PrintStream dest) {
        Thread thread = new Thread(srcIdentifier){

            @Override
            public void run() {
                Scanner sc = new Scanner(src);
                while (sc.hasNextLine()) {
                    dest.println(sc.nextLine());
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public static String getCurrentClasspath() {
        String[] urls;
        StringBuilder buffer = new StringBuilder();
        if (Thread.currentThread().getContextClassLoader() instanceof URLClassLoader) {
            URL[] urlsArray = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
            urls = new String[urlsArray.length];
            int i2 = 0;
            while (i2 < urlsArray.length) {
                urls[i2] = urlsArray[i2].getPath();
                ++i2;
            }
        } else {
            urls = System.getProperty("java.class.path").split(File.pathSeparator);
        }
        String[] stringArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            String urlStr = stringArray[n2];
            urlStr = urlStr.replaceFirst("jar:", "");
            if (IS_WINDOWS) {
                urlStr = urlStr.replaceFirst("file:\\/", "");
            }
            urlStr = urlStr.replaceFirst("file:", "");
            try {
                urlStr = URLDecoder.decode(urlStr, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            buffer.append((IS_WINDOWS ? OutProcessUtils.toUNCForm(new File(urlStr)) : new File(urlStr)).getAbsolutePath());
            buffer.append(File.pathSeparatorChar);
            ++n2;
        }
        String classpath = buffer.toString();
        classpath = classpath.substring(0, classpath.lastIndexOf(File.pathSeparatorChar));
        return classpath;
    }

    public static String generateClassPath(Class ... classes) {
        HashSet<String> urls = new HashSet<String>();
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            if (clazz != null) {
                String url = clazz.getResource(String.valueOf('/') + clazz.getName().replace('.', '/') + ".class").toExternalForm();
                int index = url.lastIndexOf(33);
                if (index != -1) {
                    url = url.substring(0, index);
                } else {
                    try {
                        url = new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getAbsolutePath();
                    }
                    catch (URISyntaxException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                url = url.replaceFirst("jar:", "");
                if (IS_WINDOWS) {
                    url = url.replaceFirst("file:\\/", "");
                }
                url = url.replaceFirst("file:", "");
                try {
                    url = URLDecoder.decode(url, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                urls.add((IS_WINDOWS ? OutProcessUtils.toUNCForm(new File(url)) : new File(url)).getAbsolutePath());
            }
            ++n2;
        }
        StringBuilder builder = new StringBuilder();
        for (String url : urls) {
            builder.append(url).append(File.pathSeparatorChar);
        }
        if (!urls.isEmpty()) {
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    private static File toUNCForm(File file) {
        Matcher matcher = WINDOWS_DRIVER_LETTER_PATTERN.matcher(file.getAbsolutePath());
        if (matcher.matches()) {
            try {
                Class<?> shellFolderClass = Class.forName("sun.awt.shell.ShellFolder");
                Object shellFolder = shellFolderClass.getDeclaredMethod("getShellFolder", File.class).invoke(null, file.toPath().getRoot().toFile());
                Object uncPath = shellFolderClass.getDeclaredMethod("getFolderColumnValue", Integer.TYPE).invoke(shellFolder, 6);
                return uncPath != null && uncPath.toString().startsWith("\\\\") ? new File(uncPath + "\\" + matcher.group(1)) : file;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file;
    }

    public static void killOutProcess(String message, Throwable cause) {
        if (System.getProperty(RUNNING_AS_OUT_PROCESS) != null) {
            throw new OutProcessDiedException(message, cause);
        }
        throw new RuntimeException("Current JVM is not a OutProcess JVM, cannot kill it.");
    }

    public static void readCommandExecuteAndRespond(DataInputStream input, DataOutputStream output, int[] length) throws Exception {
        try {
            Callable callable = OutProcessUtils.readObject(input, Callable.class);
            Serializable result = (Serializable)callable.call();
            output.writeBoolean(true);
            OutProcessUtils.writeObject(output, result, length);
        }
        catch (Throwable e2) {
            output.writeBoolean(false);
            try {
                OutProcessUtils.writeObject(output, e2, length);
            }
            catch (NotSerializableException ex) {
                OutProcessUtils.writeObject(output, new RuntimeException(ex.getMessage()), length);
            }
        }
    }

    public static <T> T readObject(DataInputStream input, Class<T> clazz) throws IOException, ClassNotFoundException {
        byte[] buffer;
        int originalLen;
        int len = originalLen = input.readInt();
        CachedBuffer cachedBuffer = BUFFER_CACHE.get();
        byte[] lastBuffer = cachedBuffer.buffer;
        if (lastBuffer.length < len) {
            buffer = cachedBuffer.allocate(len);
        } else {
            buffer = lastBuffer;
            cachedBuffer.incrementUsage(len);
            if (cachedBuffer.cacheCount > 10.0f && cachedBuffer.average() * 1.5f > (float)len) {
                cachedBuffer.reduce(5.0f, len);
            }
        }
        while (len > 0) {
            int readed = input.read(buffer, originalLen - len, len);
            if (readed == -1) break;
            len -= readed;
        }
        return OutProcessUtils.unserialize(buffer, clazz);
    }

    public static void writeObject(DataOutputStream output, Object obj, int[] length) throws IOException {
        byte[] data = OutProcessUtils.serialize(obj, length);
        output.writeInt(length[0]);
        output.write(data, 0, length[0]);
        output.flush();
    }

    public static byte[] serialize(Object obj, int[] length) throws IOException {
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        ObjectOutputStream output = new ObjectOutputStream(outputBuffer);
        try {
            output.writeObject(obj);
            output.flush();
            byte[] data = outputBuffer.toByteArray();
            length[0] = data.length;
            byte[] byArray = data;
            return byArray;
        }
        finally {
            outputBuffer.close();
            output.close();
        }
    }

    public static <T> T unserialize(byte[] data, Class<T> clazz) throws IOException, ClassNotFoundException {
        try (ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(data));){
            Object object = input.readObject();
            return (T)object;
        }
    }

    public static boolean isRunning(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e2) {
            return true;
        }
    }

    private static class CachedBuffer {
        private byte[] buffer = new byte[32];
        private float cacheCount = 0.0f;
        private float count = 0.0f;
        private float sum = 0.0f;

        private CachedBuffer() {
        }

        private byte[] allocate(int len) {
            this.buffer = new byte[(int)((float)len * 1.15f)];
            this.count = 1.0f;
            this.cacheCount = 1.0f;
            this.sum = len;
            return this.buffer;
        }

        private void reduce(float percent, int minSize) {
            this.cacheCount = 1.0f;
            int newSize = (int)((float)this.buffer.length * (1.0f - percent / 100.0f));
            if (newSize <= minSize) {
                if (this.buffer.length != minSize) {
                    newSize = minSize;
                } else {
                    return;
                }
            }
            byte[] buffertmp = new byte[newSize];
            System.arraycopy(this.buffer, 0, buffertmp, 0, buffertmp.length);
            this.buffer = buffertmp;
        }

        private float average() {
            return this.sum / this.count;
        }

        private void incrementUsage(int len) {
            this.sum += (float)len;
            this.count += 1.0f;
            this.cacheCount += 1.0f;
        }
    }
}

