/*
 * Decompiled with CFR 0.152.
 */
package dyorgio.runtime.run.as.root.impl;

import dyorgio.runtime.run.as.root.NotAuthorizedException;
import dyorgio.runtime.run.as.root.RootProcessBuilderFactory;
import dyorgio.runtime.run.as.root.UserCanceledException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class WinRootProcessBuilderFactory
implements RootProcessBuilderFactory {
    static final File ELEVATE_EXECUTABLE_PATH;

    static {
        block23: {
            boolean isX86 = System.getenv("ProgramFiles(x86)") == null;
            String libName = isX86 ? "Elevate32.exe" : "Elevate64.exe";
            URL url = WinRootProcessBuilderFactory.class.getResource(libName);
            if (url == null) {
                url = WinRootProcessBuilderFactory.class.getResource("/win/elevate/" + libName);
            }
            if (url != null) {
                try {
                    ELEVATE_EXECUTABLE_PATH = File.createTempFile("run-as-root", "-elevate");
                    ELEVATE_EXECUTABLE_PATH.deleteOnExit();
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream openStream = url.openStream();){
                        Throwable throwable2 = null;
                        Object var7_11 = null;
                        try (FileOutputStream output = new FileOutputStream(ELEVATE_EXECUTABLE_PATH);){
                            int readed;
                            byte[] buffer = new byte[32768];
                            while ((readed = openStream.read(buffer)) != -1) {
                                ((OutputStream)output).write(buffer, 0, readed);
                            }
                            output.flush();
                            break block23;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to extract Elevate executable.", ex);
                }
            }
            throw new RuntimeException("Unable to find Elevate executable.");
        }
    }

    @Override
    public ProcessBuilder create(List<String> commands) throws Exception {
        ArrayList<String> elevateCommands = new ArrayList<String>();
        elevateCommands.add("\"" + ELEVATE_EXECUTABLE_PATH.getAbsolutePath() + "\"");
        elevateCommands.add("-s 0");
        elevateCommands.add("-w");
        elevateCommands.add("--");
        elevateCommands.addAll(commands);
        return new ProcessBuilder(elevateCommands);
    }

    @Override
    public void handleCode(int code) throws NotAuthorizedException, UserCanceledException {
        switch (code) {
            case 1223: {
                throw new UserCanceledException();
            }
        }
    }

    @Override
    public void consume(Process startedProcess) {
    }
}

