/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.swing.SwingComponentWrapper;

public final class SwingContainerWrapper
extends SwingComponentWrapper
implements ContainerWrapper {
    private static final Color DB_CELL_OUTLINE = new Color(255, 0, 0);

    public SwingContainerWrapper(Container c2) {
        super(c2);
    }

    @Override
    public ComponentWrapper[] getComponents() {
        Container c2 = (Container)this.getComponent();
        ComponentWrapper[] cws = new ComponentWrapper[c2.getComponentCount()];
        for (int i2 = 0; i2 < cws.length; ++i2) {
            cws[i2] = new SwingComponentWrapper(c2.getComponent(i2));
        }
        return cws;
    }

    @Override
    public int getComponentCount() {
        return ((Container)this.getComponent()).getComponentCount();
    }

    @Override
    public Object getLayout() {
        return ((Container)this.getComponent()).getLayout();
    }

    @Override
    public final boolean isLeftToRight() {
        return ((Container)this.getComponent()).getComponentOrientation().isLeftToRight();
    }

    @Override
    public final void paintDebugCell(int x, int y, int width, int height) {
        Component c2 = (Component)this.getComponent();
        if (!c2.isShowing()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)c2.getGraphics();
        if (g2 == null) {
            return;
        }
        g2.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{2.0f, 3.0f}, 0.0f));
        g2.setPaint(DB_CELL_OUTLINE);
        g2.drawRect(x, y, width - 1, height - 1);
    }

    @Override
    public int getComponentType(boolean disregardScrollPane) {
        return 1;
    }

    @Override
    public int getLayoutHashCode() {
        long n = System.nanoTime();
        int h2 = super.getLayoutHashCode();
        if (this.isLeftToRight()) {
            h2 += 416343;
        }
        return 0;
    }
}

