/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ByteUtility {
    public static final char[] hex = "0123456789ABCDEF".toCharArray();

    public static byte[] hexToBytes(String s) {
        byte[] ret = new byte[s.length() / 2];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = (byte)Integer.parseInt(s.substring(i2 * 2, i2 * 2 + 2), 16);
        }
        return ret;
    }

    public static String bytesToHex(byte[] b2) {
        char[] ret = new char[b2.length * 3];
        int j2 = 0;
        for (int i2 = 0; i2 < b2.length; ++i2) {
            ret[j2++] = hex[(b2[i2] & 0xF0) >> 4];
            ret[j2++] = hex[b2[i2] & 0xF];
            ret[j2++] = 32;
        }
        return new String(ret);
    }

    public static String bytesToHex(byte[] b2, int length) {
        char[] ret = new char[length * 3];
        int j2 = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            ret[j2++] = hex[(b2[i2] & 0xF0) >> 4];
            ret[j2++] = hex[b2[i2] & 0xF];
            ret[j2++] = 32;
        }
        return new String(ret);
    }

    public static String byteToHex(byte b2) {
        int i2 = b2 & 0xFF;
        String strByte = Integer.toHexString(i2);
        if (strByte.length() == 1) {
            strByte = "0" + strByte;
        }
        if (strByte.length() > 2) {
            strByte = strByte.substring(strByte.length() - 1, strByte.length());
        }
        strByte = strByte.toUpperCase();
        return strByte;
    }

    public static String bytesToBin(byte[] b2) {
        String ret = "";
        boolean j2 = false;
        for (int i2 = 0; i2 < b2.length; ++i2) {
            for (int ii = 0; ii < 8; ++ii) {
                ret = ret + ((b2[i2] & 128 >> ii) > 0 ? "1" : "0");
            }
            ret = ret + "(" + ByteUtility.byteToHex(b2[i2]) + "h) ";
        }
        return ret;
    }

    public static void intTo4Bytes(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public static void intTo2Bytes(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
    }

    public static int twoBytesToInt(byte[] b2) {
        int b1 = b2[1] & 0xFF;
        int b0 = b2[0] & 0xFF;
        return (b1 << 8) + b0;
    }

    public static int twoBytesToIntLSB(byte[] b2) {
        int b1 = b2[1] & 0xFF;
        int b0 = b2[0] & 0xFF;
        return (b1 << 8) + b0;
    }

    public static int twoBytesToIntMSB(byte[] b2) {
        int b1 = b2[1] & 0xFF;
        int b0 = b2[0] & 0xFF;
        return (b0 << 8) + b1;
    }

    public static long fourBytesToLong(byte[] b2) {
        long b3 = b2[3] & 0xFF;
        long b22 = b2[2] & 0xFF;
        long b1 = b2[1] & 0xFF;
        long b0 = b2[0] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b22 << 8) + b3;
    }

    public static long fourBytesToLongByLSBFirst(byte[] b2) {
        long b3 = b2[3] & 0xFF;
        long b22 = b2[2] & 0xFF;
        long b1 = b2[1] & 0xFF;
        long b0 = b2[0] & 0xFF;
        return (b3 << 24) + (b22 << 16) + (b1 << 8) + b0;
    }

    public static byte[] random16Bytes() {
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return bytes;
    }

    public static String fourByteToDate(byte[] date) {
        long timeStamp = ByteUtility.fourBytesToLongByLSBFirst(date);
        SimpleDateFormat f2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
        long k = ByteUtility.addTimeZoneOffset(timeStamp * 1000L);
        Date d2 = new Date(k);
        return f2.format(d2);
    }

    private static long addTimeZoneOffset(long time) {
        TimeZone tz = TimeZone.getDefault();
        GregorianCalendar c2 = new GregorianCalendar(tz);
        c2.setTimeInMillis(time);
        long zoneOffset = 0L;
        zoneOffset = c2.get(15) + c2.get(16);
        return time - zoneOffset;
    }

    public static byte[] toBinArray(String hexStr) {
        char[] hexChars = hexStr.toCharArray();
        int startIndex = 0;
        int length = hexChars.length;
        if ((length & 1) != 0) {
            throw new IllegalArgumentException("Length must be even");
        }
        byte[] result = new byte[length / 2];
        for (int j2 = 0; j2 < result.length; ++j2) {
            result[j2] = (byte)(ByteUtility.hexCharToNibble(hexChars[startIndex++]) * 16 + ByteUtility.hexCharToNibble(hexChars[startIndex++]));
        }
        return result;
    }

    private static int hexCharToNibble(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Not a hex char - '" + ch + "'");
    }

    public static void main(String[] args) {
        byte[] c2 = new byte[]{-102, 0};
        System.out.println(ByteUtility.twoBytesToInt(c2));
        byte[] a2 = new byte[20];
        System.out.println(ByteUtility.bytesToHex(a2));
    }
}

