/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintStream;
import nn.pp.drvredir.ConnectionHandlerLite;
import nn.pp.drvredir.Drive;
import nn.pp.drvredir.DrvRedirNative;
import nn.pp.rc.GenericTimer;
import nn.pp.rc.RFBProfile;

class ConnectionHandlerLiteDrive
extends ConnectionHandlerLite
implements ActionListener {
    DrvRedirNative drvNative;
    String drive;
    GenericTimer timer;

    ConnectionHandlerLiteDrive(RFBProfile prof, PrintStream logger, int msIndex) throws Exception {
        super(prof, new DrvRedirNative(null), logger, msIndex);
        this.drvNative = (DrvRedirNative)this.drvAccess;
        this.drive = this.drive;
        this.timer = new GenericTimer(500, this);
    }

    static void debug(String s) {
    }

    void chooseDrive(String drive, boolean writeSupport) throws IOException {
        this.drive = drive;
        this.writeSupport = writeSupport;
    }

    @Override
    void connect() throws Exception {
        this.drvNative.initDriveRedirection();
        this.drvNative.openDrive(this.drive);
        this.drvNative.lockDriveAccess(false, false);
        this.doConnect();
        this.timer.start();
    }

    @Override
    void disconnect() {
        this.timer.stop();
        this.doDisconnect();
        try {
            this.drvNative.lockDriveAccess(true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.drvNative.closeDrive();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drvNative.cleanupDriveRedirection();
    }

    private void mediumRemovedForChange() throws Exception {
        this.drvNative.mediumRemovedForChange();
        this.proto.sendMediumRemoval();
    }

    private void mediumInsertedAfterChange() throws Exception {
        this.drvNative.lockDriveAccess(false, true);
        this.drvNative.closeDrive();
        this.drvNative.openDrive(this.drive);
        this.drvNative.lockDriveAccess(false, false);
        this.drvNative.mediumInsertedAfterChange();
        this.proto.sendMediumChange();
    }

    private void checkMediumChange() {
        try {
            switch (this.drvNative.getMediumChangeState()) {
                case 0: {
                    break;
                }
                case 1: {
                    ConnectionHandlerLiteDrive.debug("Medium has been removed.");
                    this.mediumRemovedForChange();
                    break;
                }
                case 2: {
                    ConnectionHandlerLiteDrive.debug("Medium has been changed.");
                    this.mediumInsertedAfterChange();
                }
            }
        }
        catch (Exception e2) {
            this.disconnect();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Object src = e2.getSource();
        if (src == this.timer) {
            this.checkMediumChange();
        }
    }

    public static void main(String[] args) {
        try {
            DrvRedirNative drvn = new DrvRedirNative(null);
            Drive[] drives = drvn.getAvailableDrives();
            for (int i2 = 0; i2 < drives.length; ++i2) {
                System.out.println(drives[i2].getNameAndDescription());
            }
        }
        catch (Exception drvn) {
            // empty catch block
        }
        RFBProfile rfbProfile = new RFBProfile();
        rfbProfile.remoteHost = "192.168.10.245";
        rfbProfile.username = "ADMIN";
        rfbProfile.password = "ADMIN";
        rfbProfile.driveRedirectionNoDrives = 2;
        rfbProfile.driveRedirection = true;
        try {
            ConnectionHandlerLiteDrive drive = new ConnectionHandlerLiteDrive(rfbProfile, System.out, 1);
            drive.chooseDrive("k", false);
            drive.connect();
            System.out.println("Done");
        }
        catch (IOException ex1) {
            System.out.println(ex1.getMessage());
        }
        catch (Exception ex1) {
            System.out.println(ex1.getMessage());
        }
        try {
            Thread.sleep(1000000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

