/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import nn.pp.rc.T;

class LibraryDownloader {
    LibraryDownloader() {
    }

    private static void debug(String s) {
    }

    private String getFileSuffix() throws Exception {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return ".dll";
        }
        throw new IOException(T._("Not supported by Operating System"));
    }

    private String buildSourceFileName() throws Exception {
        return "DrvRedirNative" + this.getFileSuffix();
    }

    private String getTimeString() {
        Calendar cal = Calendar.getInstance();
        int y = cal.get(1);
        int m = cal.get(2);
        int d2 = cal.get(5);
        int h2 = cal.get(11);
        int min = cal.get(12);
        int s = cal.get(13);
        String ret = new String("");
        ret = ret + y;
        if (m < 10) {
            ret = ret + "0";
        }
        ret = ret + m;
        if (d2 < 10) {
            ret = ret + "0";
        }
        ret = ret + d2;
        ret = ret + "-";
        if (h2 < 10) {
            ret = ret + "0";
        }
        ret = ret + h2;
        if (min < 10) {
            ret = ret + "0";
        }
        ret = ret + min;
        if (s < 10) {
            ret = ret + "0";
        }
        ret = ret + s;
        return ret;
    }

    private File downloadToLocal(InputStream is) throws Exception {
        int read;
        File localFile = null;
        localFile = File.createTempFile("DrvRedir-" + this.getTimeString() + "-", this.getFileSuffix());
        FileOutputStream os = new FileOutputStream(localFile);
        byte[] temp = new byte[4096];
        int totally_read = 0;
        while ((read = is.read(temp)) != -1) {
            os.write(temp, 0, read);
            totally_read += read;
        }
        os.close();
        is.close();
        LibraryDownloader.debug("Downloaded " + totally_read + " bytes of native code to " + localFile.getCanonicalPath() + ".");
        return localFile;
    }

    public File downloadFromWeb(String appletUrl) throws Exception {
        String urlString = new String(appletUrl);
        if (!appletUrl.endsWith("/")) {
            urlString = urlString + "/";
        }
        urlString = urlString + this.buildSourceFileName();
        LibraryDownloader.debug("Loading DriveRedirection from " + urlString);
        URL url = new URL(urlString);
        URLConnection urlConnection = url.openConnection();
        urlConnection.connect();
        InputStream is = urlConnection.getInputStream();
        return this.downloadToLocal(is);
    }

    public File downloadFromLocalFile() throws Exception {
        File sourceFile = new File(this.buildSourceFileName());
        InputStream is = sourceFile.exists() ? new FileInputStream(sourceFile) : LibraryDownloader.class.getClass().getResourceAsStream("/res/DrvRedirNative.dll");
        LibraryDownloader.debug("Loading DriveRedirection from file " + sourceFile.getCanonicalPath());
        return this.downloadToLocal(is);
    }
}

