/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import nn.pp.rc.ConfirmDialog;
import nn.pp.rc.ServerConsolePanelBase;
import nn.pp.rc.T;
import nn.pp.rckbd.KeyEventHandler;
import nn.pp.rckbd.KeyTranslator;

public class ButtonPanel
extends Panel {
    public static final boolean debug = false;
    ServerConsolePanelBase frame;
    KeyEventHandler keh;
    PrintStream logger;
    boolean monimode;
    int keypause;
    Vector buttons = new Vector();
    private int preferred_width = 500;
    private boolean use_preferred_width = false;
    static final int KEYDELI_ADD = 240;
    static final int KEYDELI_SEPERATE = 241;
    static final int KEYDELI_PAUSE = 242;

    public ButtonPanel(ServerConsolePanelBase frame, KeyEventHandler keh, String[] hotkeys, String[] hotkeycodes, String[] hotkeynames, PrintStream logger, boolean monimode, int keypause) {
        this.frame = frame;
        this.logger = logger;
        this.monimode = monimode;
        this.keh = keh;
        this.keypause = keypause;
        this.setLayout(new FlowLayout(0, 0, 0));
        int l = hotkeys.length;
        if (l != hotkeycodes.length) {
            logger.println(T._("Console: WARNING: hotkey definition mismatch, some buttons will be ignored"));
            l = Math.min(hotkeys.length, hotkeycodes.length);
        }
        for (int i2 = 0; i2 < l; ++i2) {
            try {
                if (hotkeycodes[i2] == null || hotkeycodes[i2].length() == 0) continue;
                JButton b2 = hotkeycodes[i2].startsWith("kvm") ? new KvmPortButton(hotkeys[i2], hotkeycodes[i2]) : new HotKeyButton(hotkeys[i2], hotkeycodes[i2], hotkeynames[i2]);
                this.add(b2);
                this.buttons.addElement(b2);
                continue;
            }
            catch (ParseException e2) {
                logger.println(T._("Console: hotkey error:") + " " + e2);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Component[] comp = this.getComponents();
        if (comp.length == 0) {
            return new Dimension(0, 0);
        }
        int bh = comp[0].getPreferredSize().height;
        int h2 = 1;
        int w = 0;
        for (int i2 = 0; i2 < comp.length; ++i2) {
            int bw = comp[i2].getPreferredSize().width;
            if ((w += bw) <= this.preferred_width) continue;
            this.use_preferred_width = true;
            w = bw;
            ++h2;
        }
        int cw = this.use_preferred_width ? this.preferred_width : w;
        return new Dimension(cw, h2 * (bh + 1));
    }

    public void setPreferredWidth(int w) {
        this.preferred_width = w;
        if (this.use_preferred_width) {
            this.setSize(w, this.getSize().height);
        }
    }

    @Override
    public void setEnabled(boolean switchOn) {
        Enumeration e2 = this.buttons.elements();
        while (e2.hasMoreElements()) {
            JButton b2 = (JButton)e2.nextElement();
            b2.setEnabled(switchOn);
        }
    }

    public void setMonitorMode(boolean moni) {
        this.monimode = moni;
    }

    public static void main(String[] args) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable content = cb.getContents(null);
        try {
            String s = (String)content.getTransferData(DataFlavor.stringFlavor);
            System.out.println(s);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class KvmPortButton
    extends JButton
    implements ActionListener {
        short portno;

        public KvmPortButton(String hotkey, String code) throws ParseException {
            super(hotkey);
            StringTokenizer st = new StringTokenizer(code);
            try {
                st.nextToken();
                this.portno = Short.parseShort(st.nextToken(), 10);
            }
            catch (Exception e2) {
                throw new ParseException(code, 0);
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ButtonPanel.this.frame.handleFocus((Component)ev.getSource());
            ButtonPanel.this.frame.console.switchKvmPort(this.portno);
        }
    }

    class ClipBoardButton
    extends JButton
    implements ActionListener {
        private static final String CONFIRM = "confirm";
        private boolean confirm;
        private Vector codes;

        public ClipBoardButton(String hotkey, String codes, String name) {
            this.setButtonKey(hotkey, codes, name);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ButtonPanel.this.frame.handleFocus((Component)ev.getSource());
            if (ButtonPanel.this.monimode) {
                return;
            }
            Stack<Short> relkeys = new Stack<Short>();
            this.codes = this.getStringFromClibBoard();
            block7: for (int i2 = 0; i2 < this.codes.size(); ++i2) {
                Short keynr = (Short)this.codes.elementAt(i2);
                short k = keynr;
                switch (k) {
                    case 242: {
                        try {
                            Thread.sleep(ButtonPanel.this.keypause);
                        }
                        catch (Exception exception) {}
                        continue block7;
                    }
                    case 241: {
                        this.releaseStackKeys(relkeys);
                    }
                    case 240: {
                        continue block7;
                    }
                    default: {
                        relkeys.push(keynr);
                        ButtonPanel.this.keh.internalPressed(keynr, KeyEventHandler.KEYBOARD);
                    }
                }
            }
            this.releaseStackKeys(relkeys);
        }

        private void releaseStackKeys(Stack keys) {
            try {
                while (true) {
                    Short keynr = (Short)keys.pop();
                    ButtonPanel.this.keh.released(keynr, KeyEventHandler.KEYBOARD);
                }
            }
            catch (EmptyStackException emptyStackException) {
                return;
            }
        }

        private void setButtonKey(String text, String kcodes, String name) {
            String keyText = text.trim();
            this.confirm = false;
            if (keyText.startsWith(CONFIRM)) {
                this.confirm = true;
                keyText = keyText.substring(CONFIRM.length());
                keyText = keyText.trim();
            }
            if (name != null && name.length() > 0) {
                this.setLabel(name);
            } else {
                this.setLabel(keyText);
            }
        }

        public Vector getStringFromClibBoard() {
            String s = null;
            Vector<Short> v = new Vector<Short>();
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = cb.getContents(null);
            try {
                s = (String)content.getTransferData(DataFlavor.stringFlavor);
                System.out.println(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            byte[] ss = s.getBytes();
            for (int i2 = 0; i2 < ss.length; ++i2) {
                int j2;
                for (j2 = 0; j2 < KeyTranslator.codetable.length; ++j2) {
                    if (KeyTranslator.codetable[j2][0] != ss[i2]) continue;
                    v.add(new Short((short)KeyTranslator.codetable[j2][1]));
                    break;
                }
                if (j2 != KeyTranslator.codetable.length - 1) continue;
                v.add(new Short(ss[i2]));
            }
            return v;
        }
    }

    class HotKeyButton
    extends JButton
    implements ActionListener {
        private static final String CONFIRM = "confirm";
        private boolean confirm;
        private Vector codes;

        public HotKeyButton(String hotkey, String codes, String name) throws ParseException {
            this.setButtonKey(hotkey, codes, name);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ButtonPanel.this.frame.handleFocus((Component)ev.getSource());
            if (ButtonPanel.this.monimode) {
                return;
            }
            if (this.confirm) {
                ConfirmDialog d2 = new ConfirmDialog(MessageFormat.format(T._("Do you really want to send \"{0}\"?"), this.getLabel()), T._("Confirmation"), 1, true);
                int x = (Toolkit.getDefaultToolkit().getScreenSize().width - d2.getWidth()) / 2;
                int y = (Toolkit.getDefaultToolkit().getScreenSize().height - d2.getHeight()) / 2;
                Point p = new Point(x, y);
                d2.setLocation(p);
                d2.show();
                boolean ok = d2.ok;
                d2.dispose();
                d2 = null;
                if (!ok) {
                    return;
                }
            }
            Stack<Short> relkeys = new Stack<Short>();
            block7: for (int i2 = 0; i2 < this.codes.size(); ++i2) {
                Short keynr = (Short)this.codes.elementAt(i2);
                short k = keynr;
                switch (k) {
                    case 242: {
                        try {
                            Thread.sleep(ButtonPanel.this.keypause);
                        }
                        catch (Exception exception) {}
                        continue block7;
                    }
                    case 241: {
                        this.releaseStackKeys(relkeys);
                    }
                    case 240: {
                        continue block7;
                    }
                    default: {
                        relkeys.push(keynr);
                        ButtonPanel.this.keh.internalPressed(keynr, KeyEventHandler.KEYBOARD);
                    }
                }
            }
            this.releaseStackKeys(relkeys);
        }

        private void releaseStackKeys(Stack keys) {
            try {
                while (true) {
                    Short keynr = (Short)keys.pop();
                    ButtonPanel.this.keh.released(keynr, KeyEventHandler.KEYBOARD);
                }
            }
            catch (EmptyStackException emptyStackException) {
                return;
            }
        }

        private void setButtonKey(String text, String kcodes, String name) throws ParseException {
            if (text == null || text.length() == 0) {
                throw new ParseException(text, 0);
            }
            String keyText = text.trim();
            this.confirm = false;
            if (keyText.startsWith(CONFIRM)) {
                this.confirm = true;
                keyText = keyText.substring(CONFIRM.length());
                keyText = keyText.trim();
            }
            if (name != null && name.length() > 0) {
                this.setLabel(name);
            } else {
                this.setLabel(keyText);
            }
            this.codes = new Vector();
            StringTokenizer st = new StringTokenizer(kcodes);
            while (st.hasMoreTokens()) {
                try {
                    int c2 = Integer.parseInt(st.nextToken(), 16);
                    this.codes.addElement(new Short((short)c2));
                }
                catch (NumberFormatException e2) {
                    throw new ParseException(kcodes, 0);
                }
            }
        }
    }
}

