/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import nn.pp.rc.RCCanvasPanel;

public class ComponentWriter {
    public static final char[] hex = "0123456789ABCDEF".toCharArray();

    public static BufferedImage captureScreenByRCCanvasPanel(RCCanvasPanel console) {
        int w = console.mysize.width;
        int h2 = console.mysize.height;
        Object ext = null;
        BufferedImage image = new BufferedImage(w, h2, 1);
        Graphics2D g2 = image.createGraphics();
        console.rdr.paint(g2, false, console.mysize);
        g2.dispose();
        return image;
    }

    public static void testRead(BufferedImage image) {
        System.out.println("testRead");
        for (int i2 = 0; i2 < 200; ++i2) {
            int color = image.getRGB(200, i2);
            byte[] argb = new byte[4];
            ComponentWriter.intTo4Bytes(argb, 0, color);
            System.out.println(ComponentWriter.bytesToHex(argb) + ",");
        }
    }

    public static void intTo4Bytes(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public static String bytesToHex(byte[] b2) {
        char[] ret = new char[b2.length * 3];
        int j2 = 0;
        for (int i2 = 0; i2 < b2.length; ++i2) {
            ret[j2++] = hex[(b2[i2] & 0xF0) >> 4];
            ret[j2++] = hex[b2[i2] & 0xF];
            ret[j2++] = 32;
        }
        return new String(ret);
    }

    public static BufferedImage captureScreen(Component comp) {
        int w = comp.getWidth();
        int h2 = comp.getHeight();
        Object ext = null;
        BufferedImage image = new BufferedImage(w, h2, 1);
        Graphics2D g2 = image.createGraphics();
        comp.paint(g2);
        g2.dispose();
        return image;
    }

    public static File writeimage(BufferedImage image, File file) throws IOException {
        String ext = null;
        try {
            ext = ComponentWriter.getSuffix(file);
        }
        catch (IOException ex) {
            ext = "png";
            file = new File(file.getAbsolutePath() + "." + ext);
        }
        if (!ext.equalsIgnoreCase("jpg") && !ext.equalsIgnoreCase("png")) {
            ext = "png";
            file = new File(file.getAbsolutePath() + "." + ext);
        }
        if (!ImageIO.write((RenderedImage)image, ext, file)) {
            throw new IOException("No writer for " + file);
        }
        return file;
    }

    public static File write(Component comp, File file) throws IOException {
        int w = comp.getWidth();
        int h2 = comp.getHeight();
        String ext = null;
        BufferedImage image = new BufferedImage(w, h2, 1);
        Graphics2D g2 = image.createGraphics();
        comp.paint(g2);
        g2.dispose();
        try {
            ext = ComponentWriter.getSuffix(file);
        }
        catch (IOException ex) {
            ext = "png";
            file = new File(file.getAbsolutePath() + "." + ext);
        }
        if (!ext.equalsIgnoreCase("jpg") && !ext.equalsIgnoreCase("png")) {
            ext = "png";
            file = new File(file.getAbsolutePath() + "." + ext);
        }
        if (!ImageIO.write((RenderedImage)image, ext, file)) {
            throw new IOException("No writer for " + file);
        }
        return file;
    }

    public static String getSuffix(File file) throws IOException {
        String filename = file.getName();
        int dot = filename.lastIndexOf(46);
        if (dot == -1) {
            throw new IOException("No suffix in file " + file);
        }
        return filename.substring(1 + dot);
    }

    public static void main(String[] args) throws IOException {
        final JTextArea comp = new JTextArea();
        comp.read(new FileReader(new File("c:\\COMMAND.TXT")), null);
        JToolBar tb = new JToolBar();
        JButton write = new JButton("write");
        write.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    ComponentWriter.write(comp, new File("test.png"));
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
        });
        tb.add(write);
        JFrame f2 = new JFrame("ComponentWriter");
        f2.setDefaultCloseOperation(3);
        Container cp = f2.getContentPane();
        cp.add(new JScrollPane(comp));
        cp.add((Component)tb, "North");
        f2.setSize(400, 300);
        f2.setLocationRelativeTo(null);
        f2.setVisible(true);
    }
}

