/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.border.BevelBorder;

class FilePreviewer
extends JComponent
implements PropertyChangeListener {
    ImageIcon thumbnail = null;

    public void init(JFileChooser fc, BufferedImage image) {
        this.setPreferredSize(new Dimension(150, 50));
        fc.addPropertyChangeListener(this);
        this.setBorder(new BevelBorder(1));
        this.setPreviewImage(image);
    }

    public void setPreviewImage(BufferedImage image) {
        this.thumbnail = new ImageIcon(image.getScaledInstance(140, -1, 4));
    }

    public void loadImage(File f2) {
        ImageIcon tmpIcon;
        this.thumbnail = f2 == null ? null : ((tmpIcon = new ImageIcon(f2.getPath())).getIconWidth() > 90 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(90, -1, 1)) : tmpIcon);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g2, x, y);
        }
    }
}

