/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import nn.pp.rc.ComponentWriter;
import nn.pp.rc.ImageViewerFrame;
import nn.pp.rc.T;

public class QuickShotThumbnailPanel
extends Panel
implements MouseListener {
    ArrayList quickShotImageFilename = new ArrayList();
    ArrayList quickShotimagesThumbnail = new ArrayList();
    File saveDirectory = null;
    int count = 1;
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel thumbnailPanel = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    Border border1 = BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151));
    Border border2 = new TitledBorder(this.border1, "Quick Shot View");
    TitledBorder titledBorder1 = new TitledBorder("");
    JPopupMenu jPopupMenu1 = new JPopupMenu();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JButton jButton3 = new JButton();
    TitledBorder titledBorder2 = new TitledBorder("");
    Border border3 = BorderFactory.createEmptyBorder();
    Border border4 = new TitledBorder(this.border3, "Quick View Shot");
    JPanel jPanel1 = new JPanel();
    Border border5 = BorderFactory.createEmptyBorder();
    Border border6 = new TitledBorder(this.border5, "Screenshot Buffer");
    Border border7 = BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151));

    public QuickShotThumbnailPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border6 = new TitledBorder(T._("Quick shot images"));
        this.border7 = new TitledBorder(BorderFactory.createEmptyBorder(), "Images");
        this.titledBorder2 = new TitledBorder("Quick Shot View");
        this.flowLayout1.setVgap(10);
        this.setLayout(this.borderLayout1);
        this.thumbnailPanel.setLayout(this.flowLayout1);
        this.thumbnailPanel.setBorder(null);
        this.thumbnailPanel.setMaximumSize(new Dimension(140, Integer.MAX_VALUE));
        this.thumbnailPanel.setMinimumSize(new Dimension(140, 10));
        this.thumbnailPanel.setPreferredSize(new Dimension(140, 10));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setBorder(this.border6);
        this.jButton1.setAlignmentY(0.0f);
        this.jButton1.setActionCommand("Save as");
        this.jButton1.setMargin(new Insets(2, 1, 2, 1));
        this.jButton1.setText("Save As");
        this.jButton2.setMargin(new Insets(2, 1, 2, 1));
        this.jButton2.setText("Clear");
        this.jButton3.setActionCommand("Save Selected");
        this.jButton3.setMargin(new Insets(2, 1, 2, 1));
        this.jButton3.setText("Delete");
        this.jPanel1.setBorder(this.border6);
        this.jPanel1.add(this.jButton1);
        this.jPanel1.add(this.jButton3);
        this.jPanel1.add(this.jButton2);
        this.jScrollPane1.getViewport().add(this.thumbnailPanel);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public void setDirectory(File dir) {
        String directory = "QuickShot-";
        directory = directory + QuickShotThumbnailPanel.getSystemDateTime();
        this.saveDirectory = new File(dir.getPath() + File.separator + directory);
        this.saveDirectory.mkdir();
    }

    public File addImage(BufferedImage image) {
        File finalFilename = null;
        String filename = "" + this.count++ + ".png";
        File file = this.saveDirectory != null ? new File(this.saveDirectory.getPath() + File.separator + filename) : new File(filename);
        try {
            finalFilename = ComponentWriter.writeimage(image, file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        this.addThumbnail(this.loadImage(finalFilename), filename);
        return finalFilename;
    }

    public ImageIcon loadImage(File f2) {
        ImageIcon tmpIcon = new ImageIcon(f2.getPath());
        ImageIcon thumbnail = new ImageIcon(tmpIcon.getImage().getScaledInstance(100, -1, 4));
        return thumbnail;
    }

    public void addThumbnail(ImageIcon thumbnail, String title) {
        JLabel label = new JLabel(title, thumbnail, 0);
        label.setToolTipText("Double click to open " + title);
        label.setVerticalTextPosition(3);
        label.setHorizontalTextPosition(0);
        this.thumbnailPanel.add(label);
        int h2 = this.thumbnailPanel.getPreferredSize().height + (this.flowLayout1.getVgap() + (int)label.getPreferredSize().getHeight());
        this.thumbnailPanel.setPreferredSize(new Dimension(140, h2));
        this.thumbnailPanel.validate();
        this.jScrollPane1.validate();
        if ((double)h2 > this.getSize().getHeight()) {
            this.jScrollPane1.getViewport().setViewPosition(new Point(1, h2));
        }
        label.addMouseListener(this);
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (e2.getClickCount() == 2) {
            JLabel label = (JLabel)e2.getSource();
            String imageFile = this.saveDirectory.getPath() + File.separator + label.getText();
            ImageViewerFrame frame = new ImageViewerFrame();
            frame.setTitle(imageFile);
            frame.openImage(imageFile);
            frame.pack();
            frame.setVisible(true);
        }
    }

    public static String getSystemDateTime() {
        GregorianCalendar cd1 = new GregorianCalendar();
        String dateTime = "";
        int s_yy = cd1.get(1);
        dateTime = dateTime + ("" + s_yy).substring(2, 4);
        int s_mon = cd1.get(2) + 1;
        if (s_mon < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_mon;
        int s_dd = cd1.get(5);
        if (s_dd < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_dd + "-";
        int s_hh = cd1.get(11);
        if (s_hh < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_hh + "";
        int s_min = cd1.get(12);
        if (s_min < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_min + "";
        int s_ss = cd1.get(13);
        if (s_ss < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_ss + "." + cd1.get(14);
        return dateTime;
    }
}

