/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import nn.pp.rc.MonitoringDataInputStream;
import nn.pp.rc.RCProto;
import nn.pp.rc.RFBHandler;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.RFBproto;
import nn.pp.rc.SasEvent;
import nn.pp.rc.T;
import nn.pp.rc.VideoSettings;

public class RFBproto_01_16
extends RFBproto
implements RCProto {
    private static final boolean debug = false;
    VideoSettings vs = new VideoSettings();
    RFBHandler handler;
    int serverMajor;
    int serverMinor;
    int bitsPerPixel;
    int depth;
    int ack_bitsPerPixel;
    int ack_depth;
    boolean bigEndian;
    boolean trueColour;
    boolean isUnsupported;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int copyRectSrcX;
    int copyRectSrcY;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int oldMod;
    boolean shiftset = false;
    boolean inNormalProtocol = false;
    String message;
    String kbdlayout;
    String osdStateMessage;
    boolean osdStateBlanking;
    int osdStateTimeout;
    MonitoringDataInputStream is_buf = null;
    ByteArrayInputStream baStream = null;
    static final int updateBufSize = 65536;
    private int updateRectSize;
    private int rectBufSize;
    private byte[] rectBuf;
    private byte[] updateBuf = new byte[65536];
    private Inflater zlibInflater = null;
    String serverCommand;
    String serverCommandParams;
    Date start;
    Date end;
    int connectionFlags = 0;
    int spCommand;
    int spCommandParam16;
    int spCommandParam8_1;
    int spCommandParam8_2;
    static boolean sasDebug = false;

    RFBproto_01_16(RFBProfile profile, PrintStream logger, RFBHandler handler) {
        super(profile, logger);
        this.handler = handler;
        this.profile = profile;
        this.logger = logger;
        this.connected = false;
    }

    private void authenticatePlain() throws IOException {
        System.out.println("Authenticating plain");
        this.writeLoginMessage(this.profile.username, 2, this.connectionFlags);
        if (this.readServerMessageType() != 33) {
            throw new IOException(T._("Protocol error: no Session Challenge"));
        }
        this.readChallengeMessage(0, 0);
        this.writeChallengeResponseMessage(this.profile.password);
    }

    private void authenticateMD5() throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e2) {
            System.out.println("MD5 not available, using plain authentication.");
            this.authenticatePlain();
            return;
        }
        this.writeLoginMessage(this.profile.username, 4, this.connectionFlags);
        if (this.readServerMessageType() != 33) {
            throw new IOException(T._("Protocol error: no Session Challenge"));
        }
        byte[] salt = this.readChallengeMessage(0, 64);
        if (salt != null) {
            digest.update(salt);
        }
        digest.update(this.profile.password.getBytes("ISO-8859-1"));
        byte[] hash = digest.digest();
        String hashString = this.binToHex(hash);
        this.writeChallengeResponseMessage(hashString);
    }

    private void authenticateSessionID() throws IOException {
        System.out.println("Authenticating via HTTP session ID");
        this.writeLoginMessage("", 1, this.connectionFlags);
        if (this.readServerMessageType() != 33) {
            throw new IOException(T._("Protocol error: no Session Challenge"));
        }
        byte[] _challenge = this.readChallengeMessage(65, 65);
        byte[] challenge = new byte[64];
        System.arraycopy(_challenge, 0, challenge, 0, 64);
        byte[] response = new byte[32];
        this.getChallengeResponse(challenge, response, 0);
        this.writeChallengeResponseMessage(response);
    }

    private void authenticate() throws IOException {
        if (this.readServerMessageType() != 32) {
            throw new IOException(T._("Protocol error: no Authentication Capabilities"));
        }
        int caps = this.readAuthCapsMessage();
        if ((caps & 4) != 0 && this.profile.username != null && this.profile.password != null) {
            this.authenticateMD5();
        } else if ((caps & 2) != 0 && this.profile.username != null && this.profile.password != null) {
            this.authenticatePlain();
        } else if ((caps & 1) != 0) {
            this.authenticateSessionID();
        } else {
            throw new IOException(T._("Server does not support authentication schemes"));
        }
        if (this.readServerMessageType() != 34) {
            throw new IOException(T._("Protocol error: no Auth Ack"));
        }
        this.is.readByte();
        this.is.readUnsignedShort();
        this.connectionFlags = (int)(this.is.readUnsignedInt() & 0xFFFFFFFFFFFFFFFFL);
    }

    private void sendSessionID() throws IOException {
        byte[] b2 = new byte[4];
        b2[0] = -94;
        this.os.write(b2);
        this.os.writeUnsignedInt(this.profile.replaySessionID);
    }

    private void sendSpSessionTimes(Date start, Date end) throws IOException {
        byte[] b2 = new byte[4];
        b2[0] = -92;
        this.os.write(b2);
        this.writeTimestamp(start);
        this.writeTimestamp(end);
    }

    private void sendSpSessionCim(int cimID) throws IOException {
        byte[] b2 = new byte[4];
        b2[0] = -95;
        this.os.write(b2);
        this.os.writeUnsignedInt(cimID);
    }

    private void sendSpSessionCimAndTimes() throws IOException {
        this.sendSpSessionCim(this.profile.replayCimId);
        this.sendSpSessionTimes(this.profile.replayStartTime, this.profile.replayEndTime);
    }

    private void sendSessionParameters() throws IOException {
        if (this.profile.replayStartTime != null && this.profile.replayEndTime != null && this.profile.replayCimId != -1) {
            this.sendSpSessionCimAndTimes();
        } else if (this.profile.replaySessionID != -1) {
            this.sendSessionID();
        } else {
            throw new IOException("No replay parameters found!");
        }
    }

    @Override
    protected void runInitialHandshake() throws IOException {
        try {
            int t;
            this.sock.setSoTimeout(5000);
            this.connectionFlags = 0;
            if (this.profile.forensicConsole) {
                this.connectionFlags |= 2;
            }
            if (this.profile.forensicNoKeyboard) {
                this.connectionFlags |= 0x10;
            } else if (this.profile.forensicFilterKeyboard) {
                this.connectionFlags |= 0x20;
            }
            if (this.profile.replaySessionID != -1 || this.profile.replayStartTime != null && this.profile.replayEndTime != null) {
                this.connectionFlags |= 4;
            }
            String nbx_prefix = null;
            if (this.profile.norbox.equals("ipv4")) {
                nbx_prefix = "IPV4TARGET=" + this.profile.norbox_ipv4target + ",";
            } else if (this.profile.norbox.equals("ipv6")) {
                nbx_prefix = "IPV6TARGET=" + this.profile.norbox_ipv6target + ",";
            }
            if (nbx_prefix != null) {
                this.os.write(nbx_prefix.getBytes("ISO-8859-1"));
            }
            this.writeHelloMsg();
            this.readVersionMsg();
            this.writeVersionMsg();
            this.logger.println(MessageFormat.format(T._("RFB: server supports protocol version {0}.{1}"), new Integer(this.serverMajor), new Integer(this.serverMinor)));
            this.authenticate();
            if ((this.connectionFlags & 4) != 0) {
                this.sendSessionParameters();
            }
            if ((t = this.readServerMessageType()) == 164) {
                this.readSpSessionTimes();
                t = this.readServerMessageType();
            }
            if (t != 7) {
                throw new IOException(T._("Protocol error: no Chat Welcome"));
            }
            this.name = this.readString();
            if (this.readServerMessageType() != 16) {
                throw new IOException(T._("Protocol error: no OSD State"));
            }
            this.readOsdStateMessage();
            if (this.readServerMessageType() != 9) {
                throw new IOException(T._("Protocol error: no Keyboard layout"));
            }
            this.readKbdLayout();
            if (this.readServerMessageType() != 18) {
                throw new IOException(T._("Protocol error: no Capability Table"));
            }
            this.readCapabilityTableMessage();
            this.writeClientInit();
            this.readServerMessageType();
            this.readServerInit();
            this.sock.setSoTimeout(0);
            this.connected = true;
        }
        catch (IOException e2) {
            this.close();
            throw e2;
        }
    }

    void writeHelloMsg() throws IOException {
        byte[] auth_bytes = new byte[11];
        System.arraycopy("e-RIC AUTH=".getBytes("ISO-8859-1"), 0, auth_bytes, 0, auth_bytes.length);
        this.os.write(auth_bytes);
        this.os.flush();
    }

    void readVersionMsg() throws IOException {
        byte[] b2 = new byte[16];
        this.is.readFully(b2);
        if (b2[0] != 101 || b2[1] != 45 || b2[2] != 82 || b2[3] != 73 || b2[4] != 67 || b2[5] != 32 || b2[6] != 82 || b2[7] != 70 || b2[8] != 66 || b2[9] != 32 || b2[10] < 48 || b2[10] > 57 || b2[11] < 48 || b2[11] > 57 || b2[12] != 46 || b2[13] < 48 || b2[13] > 57 || b2[14] < 48 || b2[14] > 57 || b2[15] != 10) {
            throw new IOException(MessageFormat.format(T._("Host {0} hasn't a valid server version (protocol error)"), this.profile.remoteHost));
        }
        this.serverMajor = (b2[10] - 48) * 10 + (b2[11] - 48);
        this.serverMinor = (b2[13] - 48) * 10 + (b2[14] - 48);
    }

    void writeVersionMsg() throws IOException {
        String versionMsg = "e-RIC RFB " + this.profile.protocol_version + "\n";
        byte[] b2 = new byte[16];
        b2 = versionMsg.getBytes();
        this.os.write(b2);
        this.os.flush();
    }

    int readAuthCapsMessage() throws IOException {
        return this.is.readUnsignedByte();
    }

    void writeLoginMessage(String user_name, int auth_method, int flags) throws IOException {
        this.os.write(32);
        this.os.write(auth_method);
        this.os.write(user_name.length() + 1);
        this.os.write(0);
        this.os.writeUnsignedInt(flags);
        this.os.write(user_name.getBytes("ISO-8859-1"));
        this.os.write(0);
    }

    byte[] readChallengeMessage(int expLen, int maxLen) throws IOException {
        int len = this.is.readUnsignedByte();
        if (expLen != 0 && len != expLen || len > maxLen) {
            throw new IOException(T._("Protocol error: bad challenge size"));
        }
        if (len > 0) {
            byte[] challenge = new byte[len];
            this.is.readFully(challenge);
            return challenge;
        }
        return null;
    }

    void writeChallengeResponseMessage(byte[] response, boolean terminate) throws IOException {
        byte[] b2 = new byte[]{33, (byte)(response.length + (terminate ? 1 : 0))};
        this.os.write(b2);
        this.os.write(response);
        if (terminate) {
            this.os.write(0);
        }
    }

    void writeChallengeResponseMessage(byte[] response) throws IOException {
        this.writeChallengeResponseMessage(response, true);
    }

    void writeChallengeResponseMessage(String response) throws IOException {
        this.writeChallengeResponseMessage(response.getBytes("ISO-8859-1"), false);
    }

    String readString() throws IOException {
        this.is.readUnsignedByte();
        return this.is.readUTF();
    }

    @Override
    void writeString(String msg) throws IOException {
        byte[] b2 = new byte[2];
        b2[0] = 7;
        this.os.write(b2);
        this.os.writeUTF(msg);
    }

    void writeClientInit() throws IOException {
        if (this.profile.shareDesktop) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.os.write((byte)this.profile.portId);
        this.os.flush();
    }

    void readServerInit() throws IOException {
        this.isUnsupported = this.is.readUnsignedByte() != 0;
        this.framebufferWidth = this.framebufferWidthPadded = this.is.readUnsignedShort();
        this.framebufferHeight = this.framebufferHeightPadded = this.is.readUnsignedShort();
        if (this.framebufferWidthPadded % 16 != 0) {
            this.framebufferWidthPadded = (this.framebufferWidthPadded / 16 + 1) * 16;
        }
        if (this.framebufferHeightPadded % 16 != 0) {
            this.framebufferHeightPadded = (this.framebufferHeightPadded / 16 + 1) * 16;
        }
        this.is.readUnsignedShort();
        Date d2 = this.readTimestamp();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] pad = new byte[3];
        this.is.readFully(pad);
        this.inNormalProtocol = true;
    }

    int readServerMessageType() throws IOException {
        this.min.increaseCounters(1);
        int type = this.is.readUnsignedByte();
        if (type == 3) {
            throw new IOException(RFBproto_01_16.getQuitReasonMsg(this.readQuitReason()));
        }
        return type;
    }

    Date readTimestamp() throws IOException {
        long sec = this.is.readUnsignedInt();
        long usec = this.is.readUnsignedInt();
        return new Date(sec * 1000L + usec / 1000L);
    }

    void writeTimestamp(Date timestamp) throws IOException {
        long msec = timestamp.getTime();
        long sec = msec / 1000L;
        long usec = msec % 1000L * 1000L;
        this.os.writeUnsignedInt(sec);
        this.os.writeUnsignedInt(usec);
    }

    void readFramebufferUpdate() throws IOException {
        byte flags = this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
        if ((flags & 1) != 0) {
            Date date = this.readTimestamp();
        }
    }

    int readQuitReason() throws IOException {
        return this.is.readByte();
    }

    void readFramebufferUpdateRectHdr() throws IOException {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectX + this.updateRectW > this.framebufferWidthPadded || this.updateRectY + this.updateRectH > this.framebufferHeightPadded) {
            throw new IOException("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
    }

    int readHWencSize() throws IOException {
        if ((this.updateRectEncoding & 0xF00) != 0 || (this.updateRectEncoding & 0x20000) != 0) {
            return this.updateRectSize;
        }
        return this.is.readInt();
    }

    void readHWencPadding(int size) throws IOException {
        if ((this.updateRectEncoding & 0xF00) != 0 || (this.updateRectEncoding & 0x20000) != 0 || size % 4 == 0) {
            return;
        }
        int pad_size = 4 - size % 4;
        for (int i2 = 0; i2 < pad_size; ++i2) {
            this.is.readByte();
        }
    }

    void readConsoleMessage() throws IOException {
        byte[] pad = new byte[3];
        this.is.readFully(pad);
        int size = this.is.readInt();
        Date d2 = this.readTimestamp();
        byte[] buf = new byte[size];
        this.is.readFully(buf, 0, size);
        this.message = new String(buf);
    }

    void readServerCommand() throws IOException {
        this.is.readUnsignedByte();
        int sizeCommand = this.is.readUnsignedShort();
        int sizeParams = this.is.readUnsignedShort();
        byte[] bufCommand = new byte[sizeCommand];
        byte[] bufParams = new byte[sizeParams];
        this.is.readFully(bufCommand, 0, sizeCommand);
        this.is.readFully(bufParams, 0, sizeParams);
        this.serverCommand = new String(bufCommand);
        this.serverCommandParams = new String(bufParams);
    }

    void readCapabilityTableMessage() throws IOException {
        int no_caps = this.is.readUnsignedByte();
        for (int i2 = 0; i2 < no_caps; ++i2) {
            int name_len = this.is.readUnsignedByte();
            int value_len = this.is.readUnsignedByte();
            byte[] name = new byte[name_len];
            byte[] value = new byte[value_len];
            this.is.readFully(name, 0, name_len);
            this.is.readFully(value, 0, value_len);
        }
    }

    void readOsdStateMessage() throws IOException {
        byte blanking = (byte)this.is.readUnsignedByte();
        this.osdStateBlanking = blanking == 1;
        this.osdStateTimeout = this.is.readUnsignedShort();
        int size = this.is.readUnsignedShort();
        this.is.readUnsignedShort();
        Date d2 = this.readTimestamp();
        byte[] buf = new byte[size];
        this.is.readFully(buf, 0, size);
        this.osdStateMessage = new String(buf);
    }

    void readKbdLayout() throws IOException {
        this.is.readUnsignedByte();
        int size = this.is.readUnsignedShort();
        byte[] buf = new byte[size];
        this.is.readFully(buf, 0, size);
        this.kbdlayout = new String(buf);
    }

    void readVideoSettingsUpdate() throws IOException {
        this.is.readUnsignedByte();
        this.vs.brightness = this.is.readUnsignedByte();
        this.vs.contrast_red = this.is.readUnsignedByte();
        this.vs.contrast_green = this.is.readUnsignedByte();
        this.vs.contrast_blue = this.is.readUnsignedByte();
        this.vs.clock = this.is.readUnsignedShort();
        this.vs.phase = this.is.readUnsignedShort();
        this.vs.x_offset = this.is.readUnsignedShort();
        this.vs.y_offset = this.is.readUnsignedShort();
        this.vs.x_res = this.is.readUnsignedShort();
        this.vs.y_res = this.is.readUnsignedShort();
        this.vs.refresh = this.is.readUnsignedShort();
        this.vs.y_max_offset = this.is.readUnsignedShort();
    }

    void readVideoQualityUpdate() throws IOException {
        this.is.readUnsignedByte();
        this.is.readUnsignedByte();
    }

    byte readRCModeReply() throws IOException {
        return this.is.readByte();
    }

    void readAckPixelFormat() throws IOException {
        byte[] pad = new byte[3];
        this.is.readFully(pad);
        this.ack_bitsPerPixel = this.is.readUnsignedByte();
        this.ack_depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.is.readUnsignedByte();
        this.is.readUnsignedShort();
        this.is.readUnsignedShort();
        this.is.readUnsignedShort();
        this.is.readUnsignedByte();
        this.is.readUnsignedByte();
        this.is.readUnsignedByte();
        this.is.readFully(pad);
    }

    synchronized void writeFramebufferUpdateRequest(int x, int y, int w, int h2, boolean incremental) throws IOException {
        this.os.write(3);
        this.os.write(incremental ? 1 : 0);
        this.os.writeUnsignedShort(x);
        this.os.writeUnsignedShort(y);
        this.os.writeUnsignedShort(w);
        this.os.writeUnsignedShort(h2);
        this.os.flush();
    }

    @Override
    void writeFullFramebufferUpdateRequest() throws IOException {
        this.writeFramebufferUpdateRequest(0, 0, this.framebufferWidthPadded, this.framebufferHeightPadded, false);
    }

    @Override
    synchronized void writeSetPixelFormat(int bitsPerPixel, int depth, boolean bigEndian, boolean trueColour, int redMax, int greenMax, int blueMax, int redShift, int greenShift, int blueShift) throws IOException {
        byte[] b2 = new byte[]{0, 0, 0, 0, (byte)bitsPerPixel, (byte)depth, (byte)(bigEndian ? 1 : 0), (byte)(trueColour ? 1 : 0), (byte)(redMax >> 8 & 0xFF), (byte)(redMax & 0xFF), (byte)(greenMax >> 8 & 0xFF), (byte)(greenMax & 0xFF), (byte)(blueMax >> 8 & 0xFF), (byte)(blueMax & 0xFF), (byte)redShift, (byte)greenShift, (byte)blueShift, 0, 0, 0};
        this.os.write(b2);
        this.os.flush();
    }

    synchronized void writeSetEncodings(int[] encs, int len) throws IOException {
        this.os.write(2);
        this.os.write(0);
        this.os.writeUnsignedShort(len);
        for (int i2 = 0; i2 < len; ++i2) {
            this.os.writeUnsignedInt(encs[i2]);
        }
        this.os.flush();
    }

    @Override
    public synchronized void writePointerEvent(boolean relative, int x, int y, int z, int pointerMask) throws IOException {
        if (this.monitorMode) {
            return;
        }
        if (!relative) {
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
        }
        this.os.write(relative ? 147 : 5);
        this.os.write(pointerMask);
        this.os.writeUnsignedShort(x);
        this.os.writeUnsignedShort(y);
        this.os.writeUnsignedShort(z);
        this.os.flush();
    }

    int readPing() throws IOException {
        this.is.readByte();
        this.is.readByte();
        this.is.readByte();
        return this.is.readInt();
    }

    synchronized void writePingReply(int serial) throws IOException {
        this.os.write(149);
        this.os.write(0);
        this.os.write(0);
        this.os.write(0);
        this.os.writeUnsignedInt(serial);
        this.os.flush();
    }

    void readBandwidthRequest() throws IOException {
        this.is.readByte();
        short len = this.is.readShort();
        byte[] b2 = new byte[len];
        this.is.readFully(b2);
    }

    synchronized void writeBandwidthTick(byte stage) throws IOException {
        byte[] b2 = new byte[]{-105, stage};
        this.os.write(b2);
        this.os.flush();
    }

    @Override
    public synchronized void writeKeyboardEvent(byte keycode) throws IOException {
        if (this.monitorMode) {
            return;
        }
        byte[] b2 = new byte[]{4, keycode};
        this.os.write(b2);
        this.os.flush();
    }

    @Override
    synchronized void writeUserPropChangeEvent(String key, String value) throws IOException {
        int keyLength = key.length();
        int valueLength = value.length();
        byte[] keyBytes = key.getBytes();
        byte[] valueBytes = value.getBytes();
        byte[] b2 = new byte[]{-121, (byte)keyLength, (byte)valueLength};
        this.os.write(b2);
        this.os.write(keyBytes, 0, keyLength);
        this.os.write(valueBytes, 0, valueLength);
        this.os.flush();
    }

    @Override
    public synchronized void writeMouseSyncEvent(byte subevent) throws IOException {
        if (this.monitorMode) {
            return;
        }
        byte[] b2 = new byte[]{-122, subevent};
        this.os.write(b2);
        this.os.flush();
    }

    synchronized void writeCursorChangeEvent(String sName) throws IOException {
        int length = sName.length();
        byte[] bytes = sName.getBytes();
        byte[] b2 = new byte[]{-120, (byte)length};
        this.os.write(b2);
        this.os.write(bytes, 0, length);
        this.os.flush();
    }

    synchronized void writeKvmSwitchEvent(short newport) throws IOException {
        if (this.monitorMode) {
            return;
        }
        this.os.write(137);
        this.os.write(0);
        this.os.writeUnsignedShort(newport);
        this.os.flush();
    }

    @Override
    synchronized void writeVideoSettingsEvent(byte event, short value) throws IOException {
        this.os.write(144);
        this.os.write(event);
        this.os.writeUnsignedShort(value);
        this.os.flush();
    }

    @Override
    synchronized void writeVideoSettingsRequest(byte request) throws IOException {
        byte[] b2 = new byte[]{-111, request};
        this.os.write(b2);
        this.os.flush();
    }

    @Override
    synchronized void writeVideoRefresh() throws IOException {
        byte[] b2 = new byte[]{-110};
        this.os.write(b2);
        this.os.flush();
    }

    public synchronized void writeRCModeRequest(byte request) throws IOException {
        byte[] b2 = new byte[]{-96, request};
        this.os.write(b2);
        this.os.flush();
    }

    public void prepareUpdateRect() throws IOException {
        if ((this.updateRectEncoding & 0xF00) != 0) {
            this.updateRectSize = this.readCompactLen();
            if (this.updateRectSize > this.rectBufSize) {
                this.rectBuf = new byte[this.updateRectSize];
                this.rectBufSize = this.updateRectSize;
            }
            int bytesTotal = this.updateRectSize;
            int dest = 0;
            if (this.zlibInflater == null) {
                this.zlibInflater = new Inflater();
            }
            while (bytesTotal > 0) {
                int portionSize = this.readCompactLen();
                this.is.readFully(this.updateBuf, 0, portionSize);
                this.zlibInflater.setInput(this.updateBuf, 0, portionSize);
                try {
                    int bytesRead = this.zlibInflater.inflate(this.rectBuf, dest, bytesTotal);
                    dest += bytesRead;
                    bytesTotal -= bytesRead;
                }
                catch (DataFormatException dfe) {
                    throw new IOException(dfe.toString());
                }
            }
            this.baStream = new ByteArrayInputStream(this.rectBuf);
            this.is_rect = this.is_buf = new MonitoringDataInputStream(this.baStream);
        } else if ((this.updateRectEncoding & 0x20000) != 0) {
            int comprSize = (int)this.is.readUnsignedInt();
            int uncomprSize = (int)this.is.readUnsignedInt();
            int read = 0;
            int dest = 0;
            int bytesTotal = uncomprSize;
            if (uncomprSize > this.rectBufSize) {
                this.rectBuf = new byte[uncomprSize];
                this.rectBufSize = uncomprSize;
            }
            Inflater decompressor = new Inflater();
            while (read < comprSize) {
                int portionSize = comprSize - read > 65536 ? 65536 : (comprSize - read) % 65536;
                this.is.readFully(this.updateBuf, 0, portionSize);
                decompressor.setInput(this.updateBuf, 0, portionSize);
                try {
                    int bytesRead = decompressor.inflate(this.rectBuf, dest, bytesTotal);
                    dest += bytesRead;
                    read += portionSize;
                    bytesTotal -= bytesRead;
                }
                catch (DataFormatException dfe) {
                    throw new IOException(dfe.toString());
                }
            }
            decompressor.end();
            this.baStream = new ByteArrayInputStream(this.rectBuf);
            this.is_rect = this.is_buf = new MonitoringDataInputStream(this.baStream);
        } else {
            this.is_rect = this.is;
        }
    }

    void readSasError() throws IOException {
        byte err = this.is.readByte();
        this.logger.println("SAS Error: " + RFBproto_01_16.getSasErrorMsg(err));
    }

    void readCausingKvmSession(SasEvent evt) throws IOException {
        long id = this.is.readUnsignedInt();
        evt.setCausingKvmSession(id);
    }

    private void readSasInputEvent(SasEvent evt) throws IOException {
        int input_type = this.is.readUnsignedByte();
        switch (input_type) {
            case 4: {
                byte keycode = this.is.readByte();
                if (sasDebug) {
                    System.out.println("Keyboard event: keycode 0x" + Integer.toHexString(keycode));
                }
                evt.setKeyEvent(input_type, keycode);
                break;
            }
            case 5: 
            case 147: {
                byte buttonMask = this.is.readByte();
                short x = this.is.readShort();
                short y = this.is.readShort();
                short z = this.is.readShort();
                if (sasDebug) {
                    System.out.println("Pointer event (" + (input_type == 5 ? "Absolute" : "Relative") + "): x = " + x + ", y = " + y + ", z = " + z + ", bm = " + buttonMask);
                }
                evt.setMouseEvent(input_type, buttonMask, x, y, z);
                break;
            }
            case 134: {
                byte type = this.is.readByte();
                if (sasDebug) {
                    System.out.println("MouseSync event: type 0x" + Integer.toHexString(type));
                }
                evt.setMouseSyncEvent(input_type, type);
                break;
            }
            default: {
                byte[] dummy = new byte[evt.len - 1];
                this.is.readFully(dummy);
                this.logger.println(T._("Unknown forensic input event received."));
                System.out.println("Unknown forensic event: 0x" + Integer.toHexString(input_type));
            }
        }
    }

    private String readSasString(int len) throws IOException {
        if (len > 0) {
            byte[] _s = new byte[len];
            this.is.readFully(_s);
            return new String(_s);
        }
        return "";
    }

    private void readSasExistingSession(SasEvent evt) throws IOException {
        byte self = this.is.readByte();
        this.is.readByte();
        this.is.readUnsignedShort();
        Date time = this.readTimestamp();
        int user_len = this.is.readUnsignedByte();
        int ip_len = this.is.readUnsignedByte();
        String user = this.readSasString(user_len);
        String ip = this.readSasString(ip_len);
        evt.setExistingSession(self != 0, user, ip, time);
    }

    private void readSasExistingKvmSession(SasEvent evt) throws IOException {
        byte excl = this.is.readByte();
        this.is.readByte();
        this.is.readUnsignedShort();
        long id = this.is.readUnsignedInt();
        Date time = this.readTimestamp();
        evt.setExistingKvmSession(id, excl != 0, time);
    }

    private void readSasUserInfo(SasEvent evt) throws IOException {
        int user_len = this.is.readUnsignedByte();
        int ip_len = this.is.readUnsignedByte();
        String user = this.readSasString(user_len);
        String ip = this.readSasString(ip_len);
        evt.setUserInfo(user, ip);
    }

    private void readSasNewSession(SasEvent evt) throws IOException {
        Date login = this.readTimestamp();
        int user_len = this.is.readUnsignedByte();
        int ip_len = this.is.readUnsignedByte();
        String user = this.readSasString(user_len);
        String ip = this.readSasString(ip_len);
        evt.setNewSession(user, ip, login);
    }

    private void readSasKvmSwitchEvent(SasEvent evt) throws IOException {
        int channel = this.is.readUnsignedByte();
        int unit = this.is.readUnsignedByte();
        int port = this.is.readUnsignedShort();
        evt.setKvmSwitchEvent(channel, unit, port);
    }

    SasEvent readSasEvent() throws IOException {
        int evt_type = this.is.readUnsignedByte();
        int len = this.is.readUnsignedShort();
        long session = this.is.readUnsignedInt();
        Date time = this.readTimestamp();
        if (sasDebug) {
            System.out.println("Got SAS event 0x" + Integer.toHexString(evt_type) + ":");
            System.out.println("Timestamp: " + time + " Session: " + session);
        }
        SasEvent evt = new SasEvent(evt_type, time, session, len);
        switch (evt.type) {
            case 5: 
            case 12: {
                break;
            }
            case 6: {
                this.readCausingKvmSession(evt);
                this.readTimestamp();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.readCausingKvmSession(evt);
                break;
            }
            case 4: {
                this.readSasNewSession(evt);
                break;
            }
            case 3: {
                this.readSasUserInfo(evt);
                break;
            }
            case 1: {
                this.readSasExistingSession(evt);
                break;
            }
            case 2: {
                this.readSasExistingKvmSession(evt);
                break;
            }
            case 10: {
                this.readCausingKvmSession(evt);
                this.readSasInputEvent(evt);
                break;
            }
            case 11: {
                this.readSasKvmSwitchEvent(evt);
                break;
            }
            default: {
                if (evt.len > 0) {
                    byte[] dummy = new byte[evt.len];
                    this.is.readFully(dummy);
                }
                this.logger.println(T._("Unknown forensic event received."));
                System.out.println("Unknown forensic event: 0x" + Integer.toHexString(evt.type));
            }
        }
        return evt;
    }

    void readSpSessionTimes() throws IOException {
        this.is.readUnsignedByte();
        this.is.readUnsignedShort();
        this.start = this.readTimestamp();
        this.end = this.readTimestamp();
    }

    Date readSpTimestamp() throws IOException {
        this.is.readUnsignedByte();
        this.is.readUnsignedShort();
        return this.readTimestamp();
    }

    void sendSpTimestamp(Date pos) throws IOException {
        this.sendSpCommand(4);
        this.writeTimestamp(pos);
    }

    void readSpCommand() throws IOException {
        this.spCommand = this.is.readByte();
        this.spCommandParam8_1 = this.is.readByte();
        this.spCommandParam8_2 = this.is.readByte();
        this.spCommandParam16 = (this.spCommandParam8_1 << 8) + (this.spCommandParam8_2 << 0);
    }

    void sendSpCommand(int type, int param8_1, int param8_2) throws IOException {
        this.os.write(163);
        this.os.write(type);
        this.os.write(param8_1);
        this.os.write(param8_2);
    }

    void sendSpCommand(int type, int param16) throws IOException {
        this.os.write(163);
        this.os.write(type);
        this.os.writeUnsignedShort(param16);
    }

    void sendSpCommand(int type) throws IOException {
        this.sendSpCommand(type, 0);
    }
}

