/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Panel;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import nn.pp.rc.JVMVersionInfo;
import nn.pp.rc.ParameterReader;
import nn.pp.rc.RFBEncoding;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.ServerConsoleFrame;
import nn.pp.rc.ServerConsolePanelBase;
import nn.pp.rc.ServerConsolePanelFactory;
import nn.pp.rc.StateMessageInterface;
import nn.pp.rc.TimerQueue;
import nn.pp.rckbd.KbdFactory;

public class RemoteConsoleLoader
extends Panel {
    ParameterReader reader;
    StateMessageInterface stateMessenger;
    public ServerConsolePanelBase scpanel = null;
    ServerConsoleFrame scframe = null;
    boolean inFrame;

    RemoteConsoleLoader(ParameterReader reader, StateMessageInterface stateMessenger) {
        this.reader = reader;
        this.stateMessenger = stateMessenger;
    }

    public void destroy() {
        if (this.scframe != null) {
            this.scframe.close();
        } else {
            this.scpanel.close();
        }
        this.scpanel = null;
        TimerQueue.cleanUp();
    }

    public void setOnCloseURL(String url, String target) {
        if (this.scframe != null) {
            this.scframe.setOnCloseURL(url, target);
        }
    }

    public boolean displayStateMsg() {
        if (this.scpanel != null) {
            return this.scpanel.displayStateMsg();
        }
        return false;
    }

    public int adjustStateMsgPos(int height) {
        if (this.scpanel != null) {
            return this.scpanel.adjustStateMsgPos(height);
        }
        return 0;
    }

    public void init(boolean inFrame, boolean start) throws Exception {
        this.init(inFrame, null, null, start);
    }

    public void init(boolean inFrame, URL codeBase, AppletContext appletContext, boolean start) throws Exception {
        int keypause;
        this.inFrame = inFrame;
        KbdFactory.applet_codebase = codeBase;
        JVMVersionInfo verInfo = JVMVersionInfo.getJVMVersionInfo();
        this.setLayout(new BorderLayout());
        RFBProfile profile = this.readProfile();
        String boardname = this.reader.readParameter("BOARD_NAME", false);
        if (boardname == null) {
            boardname = new String("");
        }
        String[] hotkeys = this.reader.readArrayParameter("hotkey_");
        String[] hotkeycodes = this.reader.readArrayParameter("hotkeycode_");
        String[] hotkeynames = this.reader.readArrayParameter("hotkeyname_");
        try {
            keypause = Integer.parseInt(this.reader.readParameter("hotkeypause", false));
        }
        catch (Exception e2) {
            keypause = 100;
        }
        boolean monitorOn = false;
        boolean monitorPerm = true;
        String s = this.reader.readParameter("MONITOR_MODE", false);
        if (s != null) {
            if (s.equals("yes")) {
                monitorOn = true;
            } else if (s.equals("sticky")) {
                monitorOn = true;
                monitorPerm = false;
            }
        }
        boolean exclusiveOn = false;
        boolean exclusivePerm = false;
        s = this.reader.readParameter("EXCLUSIVE_PERM", false);
        if (s != null) {
            if (s.equals("on")) {
                exclusivePerm = true;
                exclusiveOn = true;
            } else if (s.equals("off")) {
                exclusivePerm = true;
                exclusiveOn = false;
            } else if (s.equals("sticky")) {
                exclusivePerm = false;
                exclusiveOn = true;
            } else if (s.equals("no")) {
                exclusivePerm = false;
                exclusiveOn = false;
            }
        }
        String localcursor = this.reader.readParameter("LOCAL_CURSOR", false);
        String synckey = this.reader.readParameter("MOUSESYNC_KEY", false);
        String synckeycodes = this.reader.readParameter("MOUSESYNC_KEYCODE", false);
        String wle = this.reader.readParameter("WLAN_ENABLED", false);
        boolean is_wlanEnabled = wle != null && wle.equals("yes");
        boolean exclusiveMouse = false;
        s = this.reader.readParameter("EXCLUSIVE_MOUSE", false);
        if (s != null && s.equals("yes")) {
            exclusiveMouse = true;
        }
        String vs_type_s = this.reader.readParameter("VS_TYPE", false);
        boolean vs_type_full = true;
        if (vs_type_s != null && vs_type_s.equals("offset")) {
            vs_type_full = false;
        }
        String vs_std = this.reader.readParameter("VS_PERM_STD", false);
        String vs_adv = this.reader.readParameter("VS_PERM_ADV", false);
        int vs_perms = 0;
        if (vs_adv != null && vs_adv.equals("yes")) {
            vs_perms = 2;
        } else if (vs_std != null && vs_std.equals("yes")) {
            vs_perms = 1;
        }
        boolean use_iip = false;
        String use_iip_s = this.reader.readParameter("USE_IIP", false);
        if (use_iip_s != null && use_iip_s.equals("yes")) {
            use_iip = true;
        }
        Locale l = null;
        for (int i2 = 0; i2 < 10; ++i2) {
            try {
                l = this.getLocale();
                break;
            }
            catch (IllegalComponentStateException icse) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        if (l == null) {
            l = Locale.US;
        }
        this.scpanel = ServerConsolePanelFactory.createPanel();
        this.scpanel.init(codeBase, this.getClass().getClassLoader(), inFrame, this.stateMessenger, verInfo, boardname, hotkeys, hotkeycodes, hotkeynames, keypause, monitorOn, monitorPerm, exclusiveOn, exclusivePerm, l, synckey, synckeycodes, localcursor, exclusiveMouse, vs_perms, vs_type_full, use_iip, is_wlanEnabled, profile.driveRedirection, this.reader.readParameter("softkbd_mapping", false), this.reader.readParameter("localkbd_mapping", false), this.reader.readParameter("kbd_layout", false));
        if (inFrame) {
            String cluster_port_id = this.reader.readParameter("CLUSTER_PORT_ID", false);
            if (cluster_port_id == null) {
                cluster_port_id = "";
            }
            this.scframe = new ServerConsoleFrame(codeBase, appletContext, this.getClass().getClassLoader(), profile, boardname, cluster_port_id, this.scpanel);
            this.scpanel.setSCFrame(this.scframe);
            this.scframe.addNotify();
            this.scpanel.adjustLayout();
            this.scframe.pack();
            this.scframe.show();
        } else {
            this.add((Component)this.scpanel, "Center");
            this.scpanel.adjustLayout();
            this.scpanel.canvasSizeChanged(new Dimension(this.getSize()));
        }
        this.scpanel.setProfile(profile);
        if (start) {
            this.scpanel.start(profile);
        }
    }

    private RFBProfile readProfile() throws Exception {
        String s;
        RFBProfile prof = new RFBProfile();
        try {
            prof.primaryPort = Integer.parseInt(this.reader.readParameter("PORT", false));
            prof.sslPort = Integer.parseInt(this.reader.readParameter("SSLPORT", false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        prof.connectId = this.reader.readParameter("SESSION_ID", false);
        prof.username = this.reader.readParameter("username", false);
        prof.password = this.reader.readParameter("password", false);
        if (prof.connectId == null && (prof.username == null || prof.password == null)) {
            this.reader.parameterError("No authentication parameters found");
        }
        prof.remoteHost = this.reader.readParameter("HOST", false);
        if (prof.remoteHost == null) {
            prof.remoteHost = this.reader.getRemoteHost();
        }
        prof.norbox = this.reader.readParameter("NORBOX", false);
        if (prof.norbox == null || !prof.norbox.equals("ipv4") && !prof.norbox.equals("ipv6")) {
            prof.norbox = "no";
        }
        if (prof.norbox.equals("ipv4")) {
            prof.norbox_ipv4target = this.reader.readParameter("NORBOX_IPV4TARGET", true);
        }
        if (prof.norbox.equals("ipv6")) {
            prof.norbox_ipv6target = this.reader.readParameter("NORBOX_IPV6TARGET", true);
        }
        if (prof.norbox.equals("no") || (prof.realRemoteHost = this.reader.readParameter("REAL_HOST", false)) == null) {
            prof.realRemoteHost = prof.remoteHost;
        }
        prof.proxyHost = this.reader.readParameter("PROXY_HOST", false);
        try {
            prof.proxyPort = Integer.parseInt(this.reader.readParameter("PROXY_PORT", false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (prof.proxyHost != null && prof.proxyPort != 0) {
            prof.useProxy = true;
        }
        if ((s = this.reader.readParameter("SSL", false)) != null && s.equals("force")) {
            prof.sslRequired = true;
        }
        if (s != null && s.equals("try")) {
            prof.noTrialAndError = false;
        }
        this.readEncodingParameters2Profile(prof);
        s = this.reader.readParameter("DRIVE_REDIRECTION", false);
        if (s != null && s.equals("yes")) {
            prof.driveRedirection = true;
        }
        if ((s = this.reader.readParameter("FORENSIC_CONSOLE", false)) != null && s.equals("yes")) {
            prof.forensicConsole = true;
        }
        if ((s = this.reader.readParameter("FORENSIC_NOKBD", false)) != null && s.equals("yes")) {
            prof.forensicNoKeyboard = true;
        }
        if ((s = this.reader.readParameter("FORENSIC_FILTERKBD", false)) != null && s.equals("yes")) {
            prof.forensicFilterKeyboard = true;
        }
        try {
            prof.driveRedirectionNoDrives = Integer.parseInt(this.reader.readParameter("DRIVE_REDIRECTION_NO_DRIVES", false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        prof.protocol_version = this.reader.readParameter("PROTOCOL_VERSION", true);
        try {
            prof.portId = Integer.parseInt(this.reader.readParameter("PORT_ID", false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String s2 = this.reader.readParameter("MONITOR_MODE", false);
        prof.initialMoniMode = s2 != null && !s2.equals("no");
        try {
            prof.replaySessionID = Integer.parseInt(this.reader.readParameter("REPLAY_SESSION", false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            prof.replayStartTime = new Date(Long.parseLong(this.reader.readParameter("REPLAY_START", false)) * 1000L);
            prof.replayEndTime = new Date(Long.parseLong(this.reader.readParameter("REPLAY_END", false)) * 1000L);
            prof.replayCimId = Integer.parseInt(this.reader.readParameter("REPLAY_CIM", false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prof;
    }

    private void readEncodingParameters2Profile(RFBProfile prof) {
        String selEnc = null;
        String fixEnc = null;
        String encAdvCR = null;
        String encAdvCD = null;
        String supportHwS = null;
        boolean supportHw = false;
        try {
            selEnc = this.reader.readParameter("SelEnc", false);
            fixEnc = this.reader.readParameter("FixEnc", false);
            encAdvCD = this.reader.readParameter("AdvEncCD", false);
            encAdvCR = this.reader.readParameter("AdvEncCR", false);
            supportHwS = this.reader.readParameter("HWENC", false);
            supportHw = supportHwS != null && supportHwS.equals("yes");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (selEnc == null) {
            selEnc = "auto";
        }
        if (fixEnc == null) {
            fixEnc = "videohi";
        }
        if (encAdvCR == null) {
            encAdvCR = "video";
        }
        if (encAdvCD == null) {
            encAdvCD = "color_16bpp";
        }
        if (supportHwS == null) {
            supportHw = false;
        }
        prof.encoding = new RFBEncoding(supportHw, selEnc, fixEnc, encAdvCR, encAdvCD);
    }
}

