/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.Panel;
import java.text.MessageFormat;
import javax.swing.UIManager;
import nn.pp.rc.Jim;
import nn.pp.rc.ParameterReader;
import nn.pp.rc.RemoteConsoleLoader;
import nn.pp.rc.T;

public class SIMTestApplication
implements ParameterReader {
    GraphicsDevice graphicsDevice;
    DisplayMode orgdm;
    private String[] params;
    private RemoteConsoleLoader loader;

    @Override
    public void parameterError(String s) throws Exception {
        throw new Exception(s);
    }

    @Override
    public String getRemoteHost() throws Exception {
        return this.readParameter("HOST", true);
    }

    @Override
    public String readParameter(String reqName, boolean required) throws Exception {
        reqName = reqName.toUpperCase();
        String ret = null;
        for (int i2 = 0; i2 < this.params.length; ++i2) {
            String name = this.params[i2].toUpperCase();
            if (!name.startsWith("/" + reqName) && !name.startsWith("-" + reqName)) continue;
            if (i2 + 1 >= this.params.length) break;
            ret = this.params[i2 + 1];
            break;
        }
        if (ret == null && required) {
            this.parameterError(MessageFormat.format(T._("Required parameter \"{0}\" not found"), reqName));
        }
        return ret;
    }

    @Override
    public String[] readArrayParameter(String basename) throws Exception {
        String s;
        int index = 0;
        while (null != (s = this.readParameter(basename + index, false))) {
            ++index;
        }
        String[] hotkeys = new String[index];
        for (int i2 = 0; i2 < index; ++i2) {
            hotkeys[i2] = s = this.readParameter(basename + i2, false);
        }
        return hotkeys;
    }

    public SIMTestApplication(String[] params) {
        this.params = params;
    }

    public Panel getRemoteConsole() {
        this.loader = new RemoteConsoleLoader(this, null);
        return this.loader;
    }

    public void runRemoteConsole(boolean inFrame, boolean start) throws Exception {
        this.loader.init(inFrame, null, null, start);
    }

    public static void main(String[] params) {
        String host = params[0];
        int result = 99;
        String[] p = new String[]{"/host", host, "/port", "443", "/username", "ADMIN", "/password", "ADMIN", "/protocol_version", "01.16", "/DRIVE_REDIRECTION", "no", "/HOTKEY_0", "confirm Ctrl+Alt+Del", "/HOTKEYCODE_0", "36 f0 37 f0 4e", "/HOTKEYNAME_0", "", "/VS_PERM_STD", "yes", "/VS_PERM_ADV", "yes", "/SelEnc", "preconf", "/FixEnc", "lanhi", "/HWENC", "yes", "/MOUSESYNC_KEY", "Alt+F12", "/MOUSESYNC_KEYCODE", "37 47", "/USE_IIP", "yes"};
        SIMTestApplication app = new SIMTestApplication(p);
        app.setLookAndFeel();
        Panel remoteConsolePanel = app.getRemoteConsole();
        try {
            Jim.isCMTest = true;
            app.runRemoteConsole(true, true);
            result = app.getTestVideoResult();
            app.sendDVOString();
            app.close();
            System.out.println("result =" + result);
            System.exit(result);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(result);
        }
    }

    public int getTestVideoResult() {
        int count = 0;
        while (!this.loader.scpanel.isTestVideoResultAvailable) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (count++ <= 30) continue;
            return 99;
        }
        return this.loader.scpanel.testVideoResult;
    }

    public void sendDVOString() {
        this.loader.scpanel.sendDVOString();
    }

    public void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIManager.put("InternalFrame.titleFont", new Font("Serif", 1, 12));
    }

    public void close() {
        this.loader.scframe.close();
    }
}

