/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import nn.pp.rc.ConfirmDialog;
import nn.pp.rc.RFBproto;
import nn.pp.rc.T;
import nn.pp.rc.VideoSettings;

public class VideoSettingsFrame
extends Frame {
    Component parent;
    PrintStream logger;
    boolean monitorMode;
    boolean debug = false;
    Dialog myFrame;
    GridBagLayout gbl;
    RFBproto proto;
    int perms;
    boolean type_full;
    String boardname;
    Vector panels;
    VSButton saveBtn;
    VSButton cancelBtn;
    VSButton resetCurBtn;
    VSButton resetAllBtn;
    VSMouseAdapter mouseAdapter = new VSMouseAdapter();
    Label resInfoLbl;
    static final byte VSBrightness = 0;
    static final byte VSContrastRed = 1;
    static final byte VSContrastGreen = 2;
    static final byte VSContrastBlue = 3;
    static final byte VSClock = 4;
    static final byte VSPhase = 5;
    static final byte VSXOffset = 6;
    static final byte VSYOffset = 7;
    static final byte VSResetAll = 8;
    static final byte VSResetCurrent = 9;
    static final byte VSSaveSettings = 10;
    static final byte VSCancelSettings = 11;
    static final byte VSAutoAdjust = 12;

    public VideoSettingsFrame(Component parent, String boardname, PrintStream logger, boolean debug, boolean monitor, int vs_perms, boolean type_full) {
        this.parent = parent;
        this.logger = logger;
        this.debug = debug;
        this.monitorMode = monitor;
        this.perms = vs_perms;
        this.boardname = boardname;
        this.type_full = type_full;
        this.myFrame = null;
    }

    @Override
    public void setVisible(boolean v) {
        Window win;
        block10: {
            win = this.getAsWindow();
            if (v && !win.isShowing()) {
                Point p = this.parent.getLocationOnScreen();
                Dimension pdim = this.parent.getSize();
                Dimension cdim = win.getSize();
                int x = pdim.width - cdim.width;
                int y = pdim.height - cdim.height;
                p.translate(x, y);
                win.setLocation(p);
                if (this.proto != null) {
                    try {
                        this.proto.writeVideoSettingsRequest((byte)1);
                    }
                    catch (IOException e2) {
                        if (this.debug) {
                            this.logger.println(T._("Could not send VideoSettings request"));
                        }
                    }
                }
            } else if (!v) {
                try {
                    this.proto.writeVideoSettingsRequest((byte)2);
                }
                catch (IOException e3) {
                    if (!this.debug) break block10;
                    this.logger.println(T._("Could not send VideoSettings request"));
                }
            }
        }
        win.setVisible(v);
        if (!v) {
            win.dispose();
        }
    }

    public void close() {
        if (this.myFrame != null) {
            this.myFrame.setVisible(false);
            this.myFrame.dispose();
        }
    }

    public Window getAsWindow() {
        if (this.myFrame == null) {
            while (!(this.parent instanceof Frame) && null != (this.parent = this.parent.getParent())) {
            }
            this.myFrame = new Dialog((Frame)this.parent);
            this.gbl = new GridBagLayout();
            this.panels = new Vector();
            if (this.type_full) {
                this.panels.addElement(new VSPanel(T._("Brightness"), 0, 0, 127, 1, 1, this, this.gbl, 0, 1));
                this.panels.addElement(new VSPanel(T._("Contrast Red"), 1, 0, 255, 1, 1, this, this.gbl, 1, 1));
                this.panels.addElement(new VSPanel(T._("Contrast Green"), 2, 0, 255, 1, 1, this, this.gbl, 2, 1));
                this.panels.addElement(new VSPanel(T._("Contrast Blue"), 3, 0, 255, 1, 1, this, this.gbl, 3, 1));
                this.panels.addElement(new VSPanel(T._("Clock"), 4, 0, 4320, 2, 1, this, this.gbl, 5, 2));
                this.panels.addElement(new VSPanel(T._("Phase"), 5, 0, 31, 1, 1, this, this.gbl, 6, 2));
            }
            this.panels.addElement(new VSPanel(T._("Horizontal Offset"), 6, 0, 512, 1, 1, this, this.gbl, 7, 1));
            this.panels.addElement(new VSPanel(T._("Vertical Offset"), 7, 0, 128, 1, 1, this, this.gbl, 8, 1));
            this.saveBtn = new VSButton(T._("Save Changes"), 10, this, 1);
            this.cancelBtn = new VSButton(T._("Undo Changes"), 11, this, 1);
            this.resetAllBtn = new VSButton(T._("Reset All Modes"), 8, this, 2, T._("Do you really want to reset all settings to their factory setting?"));
            this.resetCurBtn = new VSButton(T._("Reset this Mode"), 9, this, 2, T._("Do you really want to reset this mode to its factory setting?"));
            this.saveBtn.addMouseListener(this.mouseAdapter);
            this.cancelBtn.addMouseListener(this.mouseAdapter);
            this.resetAllBtn.addMouseListener(this.mouseAdapter);
            this.resetCurBtn.addMouseListener(this.mouseAdapter);
            this.setConstraints(this.gbl, this.resetCurBtn, 1, 9, 1, 1, 1, 10.0, 10.0, 13);
            this.setConstraints(this.gbl, this.resetAllBtn, 3, 9, 1, 1, 1, 10.0, 10.0, 17);
            this.setConstraints(this.gbl, this.saveBtn, 0, 11, 1, 1, 1, 10.0, 10.0, 17);
            this.setConstraints(this.gbl, this.cancelBtn, 4, 11, 1, 1, 1, 10.0, 10.0, 13);
            this.myFrame.add(this.resetAllBtn);
            this.myFrame.add(this.resetCurBtn);
            this.myFrame.add(this.saveBtn);
            this.myFrame.add(this.cancelBtn);
            this.resInfoLbl = new Label("", 1);
            this.setConstraints(this.gbl, this.resInfoLbl, 1, 11, 3, 1, 1, 10.0, 10.0, 13);
            this.myFrame.add(this.resInfoLbl);
            this.myFrame.setLayout(this.gbl);
            this.myFrame.setBackground(SystemColor.scrollbar);
            this.myFrame.setTitle(T._("Video Settings"));
            this.myFrame.pack();
            this.myFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    VideoSettingsFrame.this.setVisible(false);
                }
            });
            if (this.proto != null) {
                this.updateVideoSettings(this.proto.vs);
            }
        }
        return this.myFrame;
    }

    public void setRFBproto(RFBproto proto) {
        this.proto = proto;
    }

    public void setMonitorMode(boolean mode) {
        this.monitorMode = mode;
    }

    public void updateVideoSettings(VideoSettings vs) {
        if (this.myFrame == null) {
            return;
        }
        VSPanel panel = this.getPanel(0);
        if (panel != null) {
            panel.update(vs.brightness);
        }
        if ((panel = this.getPanel(1)) != null) {
            panel.update(vs.contrast_red);
        }
        if ((panel = this.getPanel(2)) != null) {
            panel.update(vs.contrast_green);
        }
        if ((panel = this.getPanel(3)) != null) {
            panel.update(vs.contrast_blue);
        }
        if ((panel = this.getPanel(4)) != null) {
            panel.updateMinMax(vs.clock - 50, vs.clock + 50);
            panel.update(vs.clock);
        }
        if ((panel = this.getPanel(5)) != null) {
            panel.update(vs.phase);
        }
        if ((panel = this.getPanel(6)) != null) {
            panel.update(vs.x_offset);
        }
        if ((panel = this.getPanel(7)) != null) {
            panel.updateMinMax(0, vs.y_max_offset);
            panel.update(vs.y_offset);
        }
        this.resInfoLbl.setText(MessageFormat.format(T._("{0}x{1} {2}Hz"), new Integer(vs.x_res), new Integer(vs.y_res), new Integer(vs.refresh)));
        this.resInfoLbl.setAlignment(1);
    }

    public void sendEvent(byte event, short value) {
        block3: {
            if (null != this.proto) {
                try {
                    this.proto.writeVideoSettingsEvent(event, value);
                }
                catch (IOException e2) {
                    if (!this.debug) break block3;
                    this.logger.println(T._("Could not send VideoSettings event"));
                }
            }
        }
    }

    private VSPanel getPanel(int event) {
        Enumeration el = this.panels.elements();
        while (el.hasMoreElements()) {
            VSPanel panel = (VSPanel)el.nextElement();
            if (panel.getEventType() != event) continue;
            return panel;
        }
        return null;
    }

    private void setConstraints(GridBagLayout gbl, Component obj, int gridx, int gridy, int gridwidth, int gridheight, int fill, double weightx, double weighty, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.anchor = anchor;
        gbl.setConstraints(obj, gbc);
    }

    class VSButton
    extends Button {
        private byte event;
        private String confirm;
        private VideoSettingsFrame parent;
        private int perm_level;

        public VSButton(String label, byte event, VideoSettingsFrame parent, int perm_level) {
            super(label);
            this.confirm = null;
            this.event = event;
            this.parent = parent;
            this.perm_level = perm_level;
            this.evalPerm();
        }

        public VSButton(String label, byte event, VideoSettingsFrame parent, int perm_level, String confirm) {
            super(label);
            this.confirm = null;
            this.event = event;
            this.parent = parent;
            this.confirm = confirm;
            this.perm_level = perm_level;
            this.evalPerm();
        }

        private void evalPerm() {
            if (this.parent.perms < this.perm_level) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }

        public byte getEvent() {
            return this.event;
        }

        public String getConfirm() {
            return this.confirm;
        }
    }

    class VSPanel
    implements AdjustmentListener {
        private MyScrollbar scroll;
        private Label label;
        private MyLabel value;
        private byte event;
        private VideoSettingsFrame parent;
        private int perm_level;

        public VSPanel(String name, byte event, int min, int max, int step, int active, VideoSettingsFrame parent, GridBagLayout gbl, int ypos, int perm_level) {
            this.event = event;
            this.parent = parent;
            this.perm_level = perm_level;
            this.label = new Label(name, 1);
            this.value = new MyLabel(T._("n/a"), 1);
            this.scroll = new MyScrollbar(0, 0, 10, min, max + 10);
            this.scroll.addAdjustmentListener(this);
            this.scroll.setEnabled(false);
            this.scroll.setUnitIncrement(step);
            VideoSettingsFrame.this.setConstraints(gbl, this.label, 0, ypos, 1, 1, 1, 0.0, 0.0, 17);
            VideoSettingsFrame.this.setConstraints(gbl, this.scroll, 1, ypos, 3, 1, 2, 10.0, 10.0, 10);
            VideoSettingsFrame.this.setConstraints(gbl, this.value, 4, ypos, 1, 1, 1, 0.0, 0.0, 13);
            parent.myFrame.add(this.label);
            parent.myFrame.add(this.scroll);
            parent.myFrame.add(this.value);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent ae) {
            short newval = (short)ae.getValue();
            VideoSettingsFrame.this.sendEvent(this.event, newval);
            this.value.setText(Integer.toString(newval));
        }

        public void update(int newval) {
            this.scroll.setValue(newval);
            this.value.setText(Integer.toString(newval));
            if (this.parent.perms >= this.perm_level) {
                this.scroll.setEnabled(true);
            }
        }

        public void updateMinMax(int min, int max) {
            this.scroll.setMinimum(min);
            this.scroll.setMaximum(max + 10);
        }

        public int getEventType() {
            return this.event;
        }

        class MyLabel
        extends Label {
            public MyLabel(String text, int alignment) {
                super(text, alignment);
            }
        }

        class MyScrollbar
        extends Scrollbar {
            public MyScrollbar(int orientation, int value, int visible, int minimum, int maximum) {
                super(orientation, value, visible, minimum, maximum);
            }
        }
    }

    class VSMouseAdapter
    extends MouseAdapter {
        VSMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            block6: {
                VSButton btnSource = (VSButton)event.getSource();
                if (VideoSettingsFrame.this.monitorMode) {
                    return;
                }
                if (btnSource.getConfirm() != null) {
                    ConfirmDialog d2 = new ConfirmDialog(btnSource.getConfirm(), T._("Confirmation"), 1, true);
                    d2.show();
                    boolean ok = d2.ok;
                    d2.dispose();
                    d2 = null;
                    if (!ok) {
                        return;
                    }
                }
                if (null != VideoSettingsFrame.this.proto) {
                    try {
                        VideoSettingsFrame.this.proto.writeVideoSettingsEvent(btnSource.getEvent(), (short)0);
                    }
                    catch (IOException e2) {
                        if (!VideoSettingsFrame.this.debug) break block6;
                        VideoSettingsFrame.this.logger.println(T._("Could not send VideoSettings event"));
                    }
                }
            }
        }
    }
}

