/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rcsoftkbd;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.util.Locale;
import java.util.Vector;
import nn.pp.rckbd.KbdFactory;
import nn.pp.rckbd.KbdLayout;
import nn.pp.rckbd.KeyDef;
import nn.pp.rckbd.KeyEventHandler;
import nn.pp.rckbd.KeyTranslator;
import nn.pp.rckbd.SoftKbd;
import nn.pp.rcsoftkbd.KbdMapping;
import nn.pp.rcsoftkbd.Key;
import nn.pp.rcsoftkbd.MapDef;

public class SoftKbdImpl
extends Canvas
implements SoftKbd,
ImageObserver,
MouseListener,
MouseMotionListener {
    public static final boolean debug = false;
    public static final int MINIMUMTASTENBREITE = 17;
    public static final int MINIMUMTASTENHOEHE = 17;
    private Graphics backgraf;
    private Image keyimage = null;
    private Object sync = new Object();
    private Image backgrd;
    private int gitterbreite;
    private int gitterhoehe;
    private Key lastkey;
    private Key newkey;
    private Key[] tastenfeld;
    private byte maxpage = 0;
    private byte actualpage = 0;
    private Dimension mysize;
    private KeyEventHandler evthandler;
    private KbdMapping actualmapping;
    private boolean changed = true;
    private boolean layoutHasChanged = false;
    private Vector keystopaint;
    private Color darklinecolor = new Color(130, 130, 130);
    private Font normalfont = new Font("SansSerif", 0, 12);
    private KeyDef[] kbd_layout;
    private KbdFactory kbd_factory = KbdFactory.getInstance();
    private KeyTranslator keytrans;
    private Dialog kbdframe = null;
    private Panel kbdpanel = null;
    private String boardname;
    private boolean interactive;
    static int bla = 0;

    public SoftKbdImpl() {
        this.keystopaint = new Vector();
        this.mysize = new Dimension(0, 0);
    }

    @Override
    public void init(KeyEventHandler keh, Locale mapping, String boardname, boolean interactive) {
        if (interactive) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.enableEvents(8L);
        }
        this.interactive = interactive;
        this.evthandler = keh;
        this.boardname = boardname;
        String layout = this.evthandler.getActualLayout().getName();
        this.actualmapping = (KbdMapping)this.kbd_factory.getKbdMapping(layout, mapping);
        this.evthandler.addSoftKbdSupport(this);
        this.setLayout(this.evthandler.getActualLayout());
    }

    @Override
    public void setLayout(KbdLayout layout) {
        this.keytrans = this.kbd_factory.getKeyTranslator(layout.getName(), this.actualmapping.getLocale());
        this.layoutHasChanged = true;
        this.kbd_layout = layout.getKeyDefs();
        int maxx = 0;
        int maxy = 0;
        for (int i2 = 0; i2 < this.kbd_layout.length; ++i2) {
            if (this.kbd_layout[i2].pos_x + this.kbd_layout[i2].size_x > maxx) {
                maxx = this.kbd_layout[i2].pos_x + this.kbd_layout[i2].size_x;
            }
            if (this.kbd_layout[i2].pos_y + this.kbd_layout[i2].size_y > maxy) {
                maxy = this.kbd_layout[i2].pos_y + this.kbd_layout[i2].size_y;
            }
            if (this.kbd_layout[i2].page <= this.maxpage) continue;
            this.maxpage = this.kbd_layout[i2].page;
        }
        this.gitterbreite = 17;
        this.gitterhoehe = 17;
        this.setSize(this.gitterbreite * maxx, this.gitterhoehe * maxy);
        this.mysize = new Dimension(this.gitterbreite * maxx, this.gitterhoehe * maxy);
        this.tastenfeld = new Key[this.kbd_layout.length];
        KbdMapping kbdmap = this.actualmapping;
        boolean menubuttonok = false;
        for (int j2 = 0; j2 < this.kbd_layout.length; ++j2) {
            this.tastenfeld[j2] = new Key(this, this.kbd_layout[j2], kbdmap.getMapDef(new Short(this.kbd_layout[j2].keynr), KeyDef.SHORTNOP), new Dimension(this.kbd_layout[j2].size_x * this.gitterbreite, this.kbd_layout[j2].size_y * this.gitterhoehe), new Point(this.kbd_layout[j2].pos_x * this.gitterbreite, this.kbd_layout[j2].pos_y * this.gitterhoehe));
        }
        this.lastkey = this.tastenfeld[0];
        this.keyimage = this.actualmapping.getKeyImg(KeyDef.SHORTNOP);
        this.repaintAll();
        this.resetFrame(true);
    }

    @Override
    public void setLayout(String layout) {
        KbdLayout newkl = this.kbd_factory.getKbdLayout(layout);
        if (this.evthandler.getActualLayout() != newkl) {
            this.actualpage = 0;
            this.evthandler.init(newkl);
        }
    }

    @Override
    public void setMapping(Locale mapping) {
        String layout = this.evthandler.getActualLayout().getName();
        KbdMapping newkm = (KbdMapping)this.kbd_factory.getKbdMapping(layout, mapping);
        if (this.actualmapping != newkm) {
            this.actualmapping = newkm;
            this.evthandler.resetAllModifiers();
            this.changeModifier(KeyDef.SHORTNOP);
            this.changed = true;
            this.repaint();
        }
        this.resetFrame(false);
    }

    @Override
    public String getKeyString(Short skeynr, Short modifiers) {
        MapDef map;
        if (!this.actualmapping.hasMapping(modifiers)) {
            modifiers = KeyDef.SHORTNOP;
        }
        if ((map = this.actualmapping.getMapDef(skeynr, modifiers)) != null) {
            return map.keychar;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.mysize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.mysize;
    }

    @Override
    public Window getAsWindow(Component c2) {
        if (null == this.kbdframe) {
            this.kbdframe = new Dialog(this.getFrameOf(c2));
            this.kbdframe.setLayout(new BorderLayout());
            this.kbdframe.add(this);
            this.kbdframe.pack();
            this.kbdframe.setResizable(false);
            this.kbdframe.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    SoftKbdImpl.this.kbdframe.hide();
                }
            });
            this.resetFrame(true);
        }
        return this.kbdframe;
    }

    @Override
    public Panel getAsPanel() {
        if (this.kbdpanel == null) {
            this.kbdpanel = new Panel(new BorderLayout());
            this.kbdpanel.add(this);
        }
        return this.kbdpanel;
    }

    private Frame getFrameOf(Component c2) {
        while (!(c2 instanceof Frame)) {
            if (null != (c2 = c2.getParent())) continue;
            return null;
        }
        return (Frame)c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Graphics g2) {
        Object object = this.sync;
        synchronized (object) {
            if (this.changed) {
                if (this.backgrd == null || this.layoutHasChanged) {
                    this.backgrd = this.createImage(this.getSize().width, this.getSize().height);
                    this.backgraf = this.backgrd.getGraphics();
                    this.backgraf.setColor(this.getBackground());
                    this.backgraf.fillRect(0, 0, this.getSize().width, this.getSize().height);
                    this.layoutHasChanged = false;
                }
                this.paintkeys(this.backgraf);
            }
            g2.drawImage(this.backgrd, 0, 0, null);
            this.changed = false;
        }
    }

    @Override
    public void paint(Graphics g2) {
        this.update(g2);
    }

    public void paintkeys(Graphics graf) {
        int b2 = 0;
        boolean i2 = false;
        graf.setFont(this.normalfont);
        int fontsize = this.normalfont.getSize();
        String fontname = this.normalfont.getName();
        int fontstyle = this.normalfont.getStyle();
        for (int k = 0; k < this.keystopaint.size(); ++k) {
            Key taste = (Key)this.keystopaint.elementAt(k);
            if (taste.keydef.page != this.actualpage) continue;
            ++b2;
            int x = taste.pos.x;
            int y = taste.pos.y;
            int breite = taste.size.width;
            int hoehe = taste.size.height;
            int endx = x + breite;
            int endy = y + hoehe;
            graf.setColor(taste.backgroundcolor);
            graf.fillRect(x, y, breite, hoehe);
            graf.setColor(Color.white);
            graf.drawLine(x, y, endx, y);
            graf.drawLine(x, y, x, endy);
            graf.setColor(this.darklinecolor);
            graf.drawLine(endx - 1, endy - 1, endx - 1, y);
            graf.drawLine(endx - 1, endy - 1, x, endy - 1);
            graf.setColor(Color.black);
            if (taste.mapdef == null) continue;
            if (taste.mapdef.imgidx == -1) {
                int width;
                FontMetrics fm = graf.getFontMetrics();
                int fsize = fontsize;
                while (breite < (width = fm.stringWidth(taste.mapdef.keychar))) {
                    Font f2 = new Font(fontname, fontstyle, --fsize);
                    graf.setFont(f2);
                    fm = graf.getFontMetrics();
                }
                int height = fm.getHeight();
                int ascent = fm.getAscent();
                int leading = fm.getLeading();
                int horizMargin = x + (breite - width) / 2;
                int verMargin = y + (hoehe - height) / 2;
                graf.drawString(taste.mapdef.keychar, horizMargin, verMargin + ascent + leading);
                if (graf.getFont().equals(this.normalfont)) continue;
                graf.setFont(this.normalfont);
                continue;
            }
            KbdMapping kbdmap = this.actualmapping;
            int ImageWidth = kbdmap.getImageXPos(taste.mapdef.imgidx + 1) - kbdmap.getImageXPos(taste.mapdef.imgidx);
            graf.drawImage(this.keyimage, x + (breite - ImageWidth) / 2, y + (hoehe - kbdmap.getKeyImgHeight()) / 2, x + (breite + ImageWidth) / 2, y + (hoehe + kbdmap.getKeyImgHeight()) / 2, kbdmap.getImageXPos(taste.mapdef.imgidx), 0, kbdmap.getImageXPos(taste.mapdef.imgidx + 1), kbdmap.getKeyImgHeight(), this);
        }
        this.keystopaint.removeAllElements();
    }

    protected void repaint(Key taste) {
        this.keystopaint.addElement(taste);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintAll() {
        Object object = this.sync;
        synchronized (object) {
            this.keystopaint.removeAllElements();
            for (int k = 0; k < this.tastenfeld.length; ++k) {
                if (this.tastenfeld[k].keydef.page != this.actualpage) continue;
                this.keystopaint.addElement(this.tastenfeld[k]);
            }
        }
        if (this.backgrd != null) {
            this.backgraf.setColor(this.getBackground());
            this.backgraf.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        this.changed = true;
        this.repaint();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) != 0) {
            this.repaintAll();
            return false;
        }
        return true;
    }

    private Key isInside(Point p) {
        for (int k = 0; k < this.tastenfeld.length; ++k) {
            if (!this.tastenfeld[k].contains(p) || this.tastenfeld[k].keydef.page != this.actualpage) continue;
            return this.tastenfeld[k];
        }
        return null;
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.newkey == null || this.lastkey.keydef.keynr == -2 || this.lastkey.keydef.keynr == -3) {
            return;
        }
        this.evthandler.released(this.lastkey.shortnumber, KeyEventHandler.SOFTKEYBOARD);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (this.newkey == null) {
            return;
        }
        if (this.lastkey.keydef.keynr == -2) {
            this.actualpage = this.actualpage < this.maxpage ? (byte)(this.actualpage + 1) : (byte)0;
            this.repaintAll();
            this.changed = true;
            this.repaint();
            return;
        }
        this.evthandler.pressed(this.lastkey.shortnumber, KeyEventHandler.SOFTKEYBOARD);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        Point p = new Point(evt.getX(), evt.getY());
        if (this.lastkey.contains(p)) {
            if (!this.lastkey.isOver()) {
                this.lastkey.setOver(true);
                this.newkey = this.lastkey;
                this.changed = true;
                this.repaint();
            }
        } else {
            this.lastkey.setOver(false);
            this.newkey = this.isInside(p);
            if (this.newkey != null) {
                this.lastkey = this.newkey;
                this.lastkey.setOver(true);
            }
            this.changed = true;
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        Point p = new Point(evt.getX(), evt.getY());
        if (!this.lastkey.contains(p)) {
            if (this.lastkey.isClicked()) {
                this.mouseReleased(evt);
            }
            this.lastkey.setOver(false);
            this.newkey = this.isInside(p);
            if (this.newkey != null) {
                this.lastkey = this.newkey;
                this.lastkey.setOver(true);
            }
        }
        this.changed = true;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void processKeyEvent(KeyEvent ke) {
        int eID = ke.getID();
        switch (eID) {
            case 401: 
            case 402: {
                Short keynr = this.keytrans.translateKeyEvent(ke);
                if (keynr == null) {
                    System.out.println("ERROR: no key number found for " + ke);
                    return;
                }
                this.evthandler.handleHardKbdEvent(keynr, eID);
                ke.consume();
            }
        }
    }

    private void resetFrame(boolean pack) {
        if (null != this.kbdframe) {
            String mapping = this.actualmapping.getLocale().getDisplayName();
            String layout = this.evthandler.getActualLayout().getName();
            this.kbdframe.setTitle(this.boardname + " " + mapping + " " + layout);
            if (pack) {
                this.kbdframe.pack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeModifier(Short mod) {
        Object object = this.sync;
        synchronized (object) {
            if (this.actualmapping.getKeyImg(mod) != null) {
                this.keyimage = this.actualmapping.getKeyImg(mod);
            }
            if (!this.actualmapping.hasMapping(mod)) {
                return;
            }
            MapDef[] map = this.actualmapping.getMapDefs(mod);
            for (int k = 0; k < this.tastenfeld.length; ++k) {
                for (int i2 = 0; i2 < map.length; ++i2) {
                    if (this.tastenfeld[k].keydef.keynr != map[i2].keynr) continue;
                    this.tastenfeld[k].changeMapDef(map[i2]);
                    this.keystopaint.addElement(this.tastenfeld[k]);
                }
            }
            this.changed = true;
        }
        this.repaint();
    }

    @Override
    public void setClicked(Short skeynr, boolean clicked) {
        if (this.lastkey.shortnumber.equals(skeynr)) {
            this.lastkey.setClicked(clicked);
        } else {
            for (int k = 0; k < this.tastenfeld.length; ++k) {
                if (!this.tastenfeld[k].shortnumber.equals(skeynr)) continue;
                this.tastenfeld[k].setClicked(clicked);
            }
        }
        this.changed = true;
        this.repaint();
    }

    void repaintnow() {
        this.changed = true;
        this.repaint();
    }

    @Override
    public boolean hasMapping(Short skeynr) {
        if (this.lastkey.shortnumber.equals(skeynr)) {
            return this.actualmapping.hasMapping(skeynr);
        }
        for (int k = 0; k < this.tastenfeld.length; ++k) {
            if (!this.tastenfeld[k].shortnumber.equals(skeynr)) continue;
            return this.actualmapping.hasMapping(skeynr);
        }
        return false;
    }
}

