/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.Component;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Vector;
import nn.pp.rc.SasEvent;
import nn.pp.sara.FixedList;
import nn.pp.sara.InfoPanel;
import nn.pp.sara.InfoPanelPart;
import nn.pp.sara.UserSession;

class SessionsPanel
extends InfoPanelPart {
    Label sourceLabel;
    boolean hasSource;
    FixedList sessionList;

    SessionsPanel(InfoPanel info) {
        super(info, false);
    }

    @Override
    String getHeader() {
        return "Open Sessions";
    }

    @Override
    void addPartLayout() {
        this.sessionList = new FixedList("xxxxxxxxxxxxxxxx (888.888.888.888) - 88:88:88 - KVM excl");
        this.add((Component)this.sessionList, "Center");
    }

    private synchronized void updateList() {
        this.sessionList.removeAll();
        Vector vec = this.info.getSessions();
        Enumeration e2 = vec.elements();
        while (e2.hasMoreElements()) {
            String entry = (String)e2.nextElement();
            this.sessionList.add(entry);
        }
    }

    private synchronized void handleExistingSession(Long session, SasEvent evt) {
        UserSession e2 = new UserSession(evt.exSession.user, evt.exSession.ip, evt.exSession.loginTime, evt.exSession.self);
        this.info.putSession(session, e2);
    }

    private synchronized void handleExistingKvmSession(Long session, SasEvent evt) {
        UserSession e2 = this.info.getSession(session);
        e2.setKvm(evt.exKvmSession.kvmSessionId, true);
        e2.setExclusive(evt.exKvmSession.kvmSessionId, evt.exKvmSession.exclusive);
    }

    private synchronized void handleUserSessionOpened(Long session, SasEvent evt) {
        UserSession e2 = new UserSession(evt.newSession.user, evt.newSession.ip, evt.newSession.loginTime, false);
        this.info.putSession(session, e2);
        this.info.newEvent(evt, "New session");
    }

    private synchronized void handleUserSessionClosed(Long session, SasEvent evt) {
        this.info.newEvent(evt, "Session closed");
        this.info.removeSession(session);
    }

    private synchronized void handleKvmSessionOpened(Long session, SasEvent evt) {
        UserSession e2 = this.info.getSession(session);
        e2.setKvm(evt.causingKvmSession, true);
        this.info.newEvent(evt, "New KVM session");
    }

    private synchronized void handleKvmSessionClosed(Long session, SasEvent evt) {
        UserSession e2 = this.info.getSession(session);
        e2.setKvm(evt.causingKvmSession, false);
        this.info.newEvent(evt, "KVM Session closed");
    }

    private synchronized void handleKvmExclusiveOn(Long session, SasEvent evt) {
        UserSession e2 = this.info.getSession(session);
        e2.setExclusive(evt.causingKvmSession, true);
        this.info.newEvent(evt, "KVM Exclusive mode entered");
    }

    private synchronized void handleKvmExclusiveOff(Long session, SasEvent evt) {
        UserSession e2 = this.info.getSession(session);
        e2.setExclusive(evt.causingKvmSession, false);
        this.info.newEvent(evt, "KVM Exclusive mode left");
    }

    private synchronized void resetSessions() {
        this.info.removeAllSessions();
    }

    @Override
    void handlePartSasEvent(SasEvent evt) {
        Long session = new Long(evt.session);
        switch (evt.type) {
            case 1: {
                if (evt.exSession == null) break;
                this.handleExistingSession(session, evt);
                break;
            }
            case 2: {
                if (evt.exKvmSession == null) break;
                this.handleExistingKvmSession(session, evt);
                break;
            }
            case 4: {
                this.handleUserSessionOpened(session, evt);
                break;
            }
            case 5: {
                this.handleUserSessionClosed(session, evt);
                break;
            }
            case 6: {
                this.handleKvmSessionOpened(session, evt);
                break;
            }
            case 7: {
                this.handleKvmSessionClosed(session, evt);
                break;
            }
            case 8: {
                this.handleKvmExclusiveOn(session, evt);
                break;
            }
            case 9: {
                this.handleKvmExclusiveOff(session, evt);
                break;
            }
            case 12: {
                this.resetSessions();
                break;
            }
            default: {
                return;
            }
        }
        this.updateList();
    }
}

