/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import nn.pp.rc.FixedLabel;
import nn.pp.sara.FixedScrollbar;
import nn.pp.sara.ReplayPanel;

public class SliderPanel
extends Panel
implements AdjustmentListener {
    private int sliderMin = 0;
    private int sliderMax = 1000;
    private int sliderInc = 10;
    private boolean adjusting = false;
    ReplayPanel replay;
    FixedLabel timeLabel;
    Scrollbar timeSlider;
    Date currentPos;
    SimpleDateFormat dateFormat;
    Date time1 = new Date();
    Date time2 = new Date();

    public SliderPanel(ReplayPanel replay) {
        this.replay = replay;
        this.addLayout();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    private void addLayout() {
        this.timeLabel = new FixedLabel("  8888-88-88 88:88:88  ");
        this.timeSlider = new FixedScrollbar(0, 300);
        this.timeSlider.addAdjustmentListener(this);
        this.timeSlider.setMinimum(this.sliderMin);
        this.timeSlider.setMaximum(this.sliderMax);
        this.timeSlider.setVisibleAmount(1);
        this.timeSlider.setPageIncrement(this.sliderInc);
        this.setLayout(new GridLayout(1, 1));
        Panel p = new Panel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.timeSlider, "Center");
        p.add((Component)this.timeLabel, "East");
        this.add(p);
    }

    private int getPosFromTime(Date time) {
        long diffWhole = this.time2.getTime() - this.time1.getTime();
        long diff = time.getTime() - this.time1.getTime();
        if (diffWhole == 0L) {
            return 0;
        }
        long pos = diff * (long)(this.sliderMax - this.sliderMin) / diffWhole + (long)this.sliderMin;
        return (int)pos;
    }

    private Date getTimeFromPos(int pos) {
        long diffWhole = this.time2.getTime() - this.time1.getTime();
        long t = (long)(pos - this.sliderMin) * diffWhole / (long)(this.sliderMax - this.sliderMin) + this.time1.getTime();
        return new Date(t);
    }

    @Override
    public void setEnabled(boolean b2) {
        this.timeLabel.setEnabled(b2);
        this.timeSlider.setEnabled(b2);
        super.setEnabled(b2);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e2) {
        Object src = e2.getSource();
        if (src == this.timeSlider) {
            if (e2.getValueIsAdjusting()) {
                this.adjusting = true;
            } else {
                this.replay.seek(this.getTimeFromPos(this.timeSlider.getValue()));
                this.adjusting = false;
            }
        }
    }

    synchronized String timeToString(Date time) {
        return this.dateFormat.format(time);
    }

    Date getCurrentPos() {
        return this.currentPos;
    }

    void setTime(Date time) {
        this.currentPos = time;
        this.timeLabel.setText(this.timeToString(time));
        if (!this.adjusting) {
            this.timeSlider.setValue(this.getPosFromTime(time));
        }
    }

    void setReplayTimes(Date time1, Date time2) {
        this.time1 = time1;
        this.time2 = time2;
    }

    void play() {
        this.timeSlider.setEnabled(true);
    }

    void pause() {
        this.timeSlider.setEnabled(false);
    }

    void stop() {
        this.timeLabel.setText("");
        this.timeSlider.setValue(0);
        this.timeSlider.setEnabled(false);
    }
}

