/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import nn.pp.rc.FixedLabel;
import nn.pp.sara.FixedScrollbar;
import nn.pp.sara.ReplayPanel;

class SpeedPanel
extends Panel
implements AdjustmentListener {
    int currentSpeed;
    ReplayPanel replay;
    Scrollbar speedBar;
    Label speedLabel;
    private int speedMax = 5;
    private int scrollbarMin = -this.speedMax;
    private int scrollbarMax = this.speedMax + 1;

    SpeedPanel(ReplayPanel replay) {
        this.replay = replay;
        this.addLayout();
        this.setSpeed(0, true);
    }

    private void addLayout() {
        this.setLayout(new BorderLayout());
        this.speedBar = new FixedScrollbar(0, 100);
        this.speedLabel = new FixedLabel("8/888 x");
        this.speedBar.addAdjustmentListener(this);
        this.speedBar.setMinimum(this.scrollbarMin);
        this.speedBar.setMaximum(this.scrollbarMax);
        this.speedBar.setVisibleAmount(1);
        this.speedBar.setPageIncrement(1);
        Panel p = new Panel(new FlowLayout(1, 0, 8));
        Panel p1 = new Panel(new BorderLayout());
        p1.add((Component)new Label("Speed: "), "West");
        p1.add((Component)this.speedBar, "Center");
        p1.add((Component)this.speedLabel, "East");
        p.add(p1);
        this.add((Component)p, "Center");
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e2) {
        Object src = e2.getSource();
        if (src == this.speedBar && !e2.getValueIsAdjusting()) {
            this.setSpeed(this.speedBar.getValue(), false);
        }
    }

    void setSpeed(int speed, boolean adjustSlider) {
        this.currentSpeed = speed;
        String s = speed < 0 ? "1/" + Math.round(Math.pow(2.0, -speed)) : "" + Math.round(Math.pow(2.0, speed));
        this.speedLabel.setText(s + "x");
        if (adjustSlider) {
            this.speedBar.setValue(speed);
        }
        this.replay.setSpeed(speed);
    }
}

