/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import nn.pp.sara.UserKvmSession;

class UserSession {
    String user;
    String ip;
    Date time;
    boolean self;
    private Hashtable kvmTable;
    SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");

    UserSession(String user, String ip, Date time, boolean self) {
        this.user = user;
        this.ip = ip;
        this.self = self;
        this.time = time;
        this.kvmTable = new Hashtable();
    }

    public synchronized String toString() {
        String s = "";
        if (this.self) {
            s = s + "* ";
        }
        s = s + this.user + " (" + this.ip + ") - " + this.dateFormat.format(this.time).toString();
        int size = this.kvmTable.size();
        if (size > 0) {
            s = s + " - KVM";
            if (size > 1) {
                s = s + " (" + size + ")";
            }
            Enumeration e2 = this.kvmTable.elements();
            while (e2.hasMoreElements()) {
                UserKvmSession entry = (UserKvmSession)e2.nextElement();
                if (!entry.exclusive) continue;
                s = s + " excl";
                break;
            }
        }
        return s;
    }

    synchronized void putKvm(Long key, UserKvmSession newEntry) {
        UserKvmSession e2 = (UserKvmSession)this.kvmTable.get(key);
        if (e2 != null) {
            System.out.println("Already found KVM session 0x" + Long.toHexString(key));
            this.kvmTable.remove(key);
        }
        this.kvmTable.put(key, newEntry);
    }

    synchronized UserKvmSession getKvm(Long key) {
        UserKvmSession e2 = (UserKvmSession)this.kvmTable.get(key);
        if (e2 == null) {
            e2 = new UserKvmSession(false);
            this.putKvm(key, e2);
        }
        return e2;
    }

    synchronized void removeKvm(Long key) {
        this.kvmTable.remove(key);
    }

    synchronized void setKvm(long kvmId, boolean kvm) {
        Long id = new Long(kvmId);
        if (kvm) {
            this.putKvm(id, new UserKvmSession(false));
        } else {
            this.removeKvm(id);
        }
    }

    synchronized void setExclusive(long kvmId, boolean excl) {
        UserKvmSession kvm = this.getKvm(new Long(kvmId));
        kvm.exclusive = excl;
    }
}

