/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;

public class NumberUtils {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Long LONG_MINUS_ONE = -1L;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_MINUS_ONE = -1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Short SHORT_MINUS_ONE = -1;
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Byte BYTE_MINUS_ONE = -1;
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final Double DOUBLE_MINUS_ONE = -1.0;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Float FLOAT_MINUS_ONE = Float.valueOf(-1.0f);

    public static int toInt(String str) {
        return NumberUtils.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return NumberUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static float toFloat(String str) {
        return NumberUtils.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static byte toByte(String str) {
        return NumberUtils.toByte(str, (byte)0);
    }

    public static byte toByte(String str, byte defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static short toShort(String str) {
        return NumberUtils.toShort(str, (short)0);
    }

    public static short toShort(String str, short defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Number createNumber(String str) throws NumberFormatException {
        String mant;
        String dec;
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (str.startsWith("--")) {
            return null;
        }
        if (str.startsWith("0x") || str.startsWith("-0x") || str.startsWith("0X") || str.startsWith("-0X")) {
            return NumberUtils.createInteger(str);
        }
        char lastChar = str.charAt(str.length() - 1);
        int decPos = str.indexOf(46);
        int expPos = str.indexOf(101) + str.indexOf(69) + 1;
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos < decPos || expPos > str.length()) {
                    throw new NumberFormatException(String.valueOf(str) + " is not a valid number.");
                }
                dec = str.substring(decPos + 1, expPos);
            } else {
                dec = str.substring(decPos + 1);
            }
            mant = str.substring(0, decPos);
        } else {
            if (expPos > -1) {
                if (expPos > str.length()) {
                    throw new NumberFormatException(String.valueOf(str) + " is not a valid number.");
                }
                mant = str.substring(0, expPos);
            } else {
                mant = str;
            }
            dec = null;
        }
        if (!Character.isDigit(lastChar) && lastChar != '.') {
            String exp = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length() - 1) : null;
            String numeric = str.substring(0, str.length() - 1);
            boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec == null && exp == null && (numeric.charAt(0) == '-' && NumberUtils.isDigits(numeric.substring(1)) || NumberUtils.isDigits(numeric))) {
                        try {
                            return NumberUtils.createLong(numeric);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(numeric);
                        }
                    }
                    throw new NumberFormatException(String.valueOf(str) + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f2 = NumberUtils.createFloat(numeric);
                        if (!f2.isInfinite() && (f2.floatValue() != 0.0f || allZeros)) {
                            return f2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d2 = NumberUtils.createDouble(numeric);
                        if (!d2.isInfinite() && ((double)d2.floatValue() != 0.0 || allZeros)) {
                            return d2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    try {
                        return NumberUtils.createBigDecimal(numeric);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            throw new NumberFormatException(String.valueOf(str) + " is not a valid number.");
        }
        String exp = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length()) : null;
        if (dec == null && exp == null) {
            try {
                return NumberUtils.createInteger(str);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return NumberUtils.createLong(str);
                }
                catch (NumberFormatException numberFormatException2) {
                    return NumberUtils.createBigInteger(str);
                }
            }
        }
        boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp);
        try {
            Float f3 = NumberUtils.createFloat(str);
            if (!f3.isInfinite() && (f3.floatValue() != 0.0f || allZeros)) {
                return f3;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            Double d3 = NumberUtils.createDouble(str);
            if (!d3.isInfinite() && (d3 != 0.0 || allZeros)) {
                return d3;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return NumberUtils.createBigDecimal(str);
    }

    private static boolean isAllZeros(String str) {
        if (str == null) {
            return true;
        }
        int i2 = str.length() - 1;
        while (i2 >= 0) {
            if (str.charAt(i2) != '0') {
                return false;
            }
            --i2;
        }
        return str.length() > 0;
    }

    public static Float createFloat(String str) {
        if (str == null) {
            return null;
        }
        return Float.valueOf(str);
    }

    public static Double createDouble(String str) {
        if (str == null) {
            return null;
        }
        return Double.valueOf(str);
    }

    public static Integer createInteger(String str) {
        if (str == null) {
            return null;
        }
        return Integer.decode(str);
    }

    public static Long createLong(String str) {
        if (str == null) {
            return null;
        }
        return Long.decode(str);
    }

    public static BigInteger createBigInteger(String str) {
        if (str == null) {
            return null;
        }
        return new BigInteger(str);
    }

    public static BigDecimal createBigDecimal(String str) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        return new BigDecimal(str);
    }

    public static long min(long[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long min = array[0];
        int i2 = 1;
        while (i2 < array.length) {
            if (array[i2] < min) {
                min = array[i2];
            }
            ++i2;
        }
        return min;
    }

    public static int min(int[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int min = array[0];
        int j2 = 1;
        while (j2 < array.length) {
            if (array[j2] < min) {
                min = array[j2];
            }
            ++j2;
        }
        return min;
    }

    public static short min(short[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        short min = array[0];
        int i2 = 1;
        while (i2 < array.length) {
            if (array[i2] < min) {
                min = array[i2];
            }
            ++i2;
        }
        return min;
    }

    public static byte min(byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        byte min = array[0];
        int i2 = 1;
        while (i2 < array.length) {
            if (array[i2] < min) {
                min = array[i2];
            }
            ++i2;
        }
        return min;
    }

    public static double min(double[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double min = array[0];
        int i2 = 1;
        while (i2 < array.length) {
            if (Double.isNaN(array[i2])) {
                return Double.NaN;
            }
            if (array[i2] < min) {
                min = array[i2];
            }
            ++i2;
        }
        return min;
    }

    public static float min(float[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float min = array[0];
        int i2 = 1;
        while (i2 < array.length) {
            if (Float.isNaN(array[i2])) {
                return Float.NaN;
            }
            if (array[i2] < min) {
                min = array[i2];
            }
            ++i2;
        }
        return min;
    }

    public static long max(long[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long max = array[0];
        int j2 = 1;
        while (j2 < array.length) {
            if (array[j2] > max) {
                max = array[j2];
            }
            ++j2;
        }
        return max;
    }

    public static int max(int[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int max = array[0];
        int j2 = 1;
        while (j2 < array.length) {
            if (array[j2] > max) {
                max = array[j2];
            }
            ++j2;
        }
        return max;
    }

    public static short max(short[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        short max = array[0];
        int i2 = 1;
        while (i2 < array.length) {
            if (array[i2] > max) {
                max = array[i2];
            }
            ++i2;
        }
        return max;
    }

    public static byte max(byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        byte max = array[0];
        int i2 = 1;
        while (i2 < array.length) {
            if (array[i2] > max) {
                max = array[i2];
            }
            ++i2;
        }
        return max;
    }

    public static double max(double[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double max = array[0];
        int j2 = 1;
        while (j2 < array.length) {
            if (Double.isNaN(array[j2])) {
                return Double.NaN;
            }
            if (array[j2] > max) {
                max = array[j2];
            }
            ++j2;
        }
        return max;
    }

    public static float max(float[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float max = array[0];
        int j2 = 1;
        while (j2 < array.length) {
            if (Float.isNaN(array[j2])) {
                return Float.NaN;
            }
            if (array[j2] > max) {
                max = array[j2];
            }
            ++j2;
        }
        return max;
    }

    public static long min(long a2, long b2, long c2) {
        if (b2 < a2) {
            a2 = b2;
        }
        if (c2 < a2) {
            a2 = c2;
        }
        return a2;
    }

    public static int min(int a2, int b2, int c2) {
        if (b2 < a2) {
            a2 = b2;
        }
        if (c2 < a2) {
            a2 = c2;
        }
        return a2;
    }

    public static short min(short a2, short b2, short c2) {
        if (b2 < a2) {
            a2 = b2;
        }
        if (c2 < a2) {
            a2 = c2;
        }
        return a2;
    }

    public static byte min(byte a2, byte b2, byte c2) {
        if (b2 < a2) {
            a2 = b2;
        }
        if (c2 < a2) {
            a2 = c2;
        }
        return a2;
    }

    public static double min(double a2, double b2, double c2) {
        return Math.min(Math.min(a2, b2), c2);
    }

    public static float min(float a2, float b2, float c2) {
        return Math.min(Math.min(a2, b2), c2);
    }

    public static long max(long a2, long b2, long c2) {
        if (b2 > a2) {
            a2 = b2;
        }
        if (c2 > a2) {
            a2 = c2;
        }
        return a2;
    }

    public static int max(int a2, int b2, int c2) {
        if (b2 > a2) {
            a2 = b2;
        }
        if (c2 > a2) {
            a2 = c2;
        }
        return a2;
    }

    public static short max(short a2, short b2, short c2) {
        if (b2 > a2) {
            a2 = b2;
        }
        if (c2 > a2) {
            a2 = c2;
        }
        return a2;
    }

    public static byte max(byte a2, byte b2, byte c2) {
        if (b2 > a2) {
            a2 = b2;
        }
        if (c2 > a2) {
            a2 = c2;
        }
        return a2;
    }

    public static double max(double a2, double b2, double c2) {
        return Math.max(Math.max(a2, b2), c2);
    }

    public static float max(float a2, float b2, float c2) {
        return Math.max(Math.max(a2, b2), c2);
    }

    public static boolean isDigits(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        int i2 = 0;
        while (i2 < str.length()) {
            if (!Character.isDigit(str.charAt(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isNumber(String str) {
        block23: {
            if (StringUtils.isEmpty(str)) {
                return false;
            }
            chars = str.toCharArray();
            sz = chars.length;
            hasExp = false;
            hasDecPoint = false;
            allowSigns = false;
            foundDigit = false;
            v0 = start = chars[0] == '-' ? 1 : 0;
            if (sz <= start + 1 || chars[start] != '0' || chars[start + 1] != 'x') break block23;
            i = start + 2;
            if (i != sz) ** GOTO lbl17
            return false;
lbl-1000:
            // 1 sources

            {
                if (!(chars[i] >= '0' && chars[i] <= '9' || chars[i] >= 'a' && chars[i] <= 'f' || chars[i] >= 'A' && chars[i] <= 'F')) {
                    return false;
                }
                ++i;
lbl17:
                // 2 sources

                ** while (i < chars.length)
            }
lbl18:
            // 1 sources

            return true;
        }
        --sz;
        i = start;
        while (i < sz || i < sz + 1 && allowSigns && !foundDigit) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
            } else if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
            } else if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
            } else if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
            } else {
                return false;
            }
            ++i;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit != false && hasExp == false && hasDecPoint == false;
            }
            return false;
        }
        return allowSigns == false && foundDigit != false;
    }
}

