/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.util;

public class DnsUtils {
    private DnsUtils() {
    }

    private static boolean isUpper(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }

    public static String normalize(String s) {
        int remaining;
        if (s == null) {
            return null;
        }
        int pos = 0;
        for (remaining = s.length(); remaining > 0 && !DnsUtils.isUpper(s.charAt(pos)); --remaining) {
            ++pos;
        }
        if (remaining > 0) {
            StringBuilder buf = new StringBuilder(s.length());
            buf.append(s, 0, pos);
            while (remaining > 0) {
                char c2 = s.charAt(pos);
                if (DnsUtils.isUpper(c2)) {
                    buf.append((char)(c2 + 32));
                } else {
                    buf.append(c2);
                }
                ++pos;
                --remaining;
            }
            return buf.toString();
        }
        return s;
    }
}

