/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;

public final class Address {
    public static final int IPv4 = 1;
    public static final int IPv6 = 2;

    private Address() {
    }

    private static byte[] parseV4(String s) {
        byte[] values = new byte[4];
        int length = s.length();
        int currentOctet = 0;
        int currentValue = 0;
        int numDigits = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s.charAt(i2);
            if (c2 >= '0' && c2 <= '9') {
                if (numDigits == 3) {
                    return null;
                }
                if (numDigits > 0 && currentValue == 0) {
                    return null;
                }
                ++numDigits;
                currentValue *= 10;
                if ((currentValue += c2 - 48) <= 255) continue;
                return null;
            }
            if (c2 == '.') {
                if (currentOctet == 3) {
                    return null;
                }
                if (numDigits == 0) {
                    return null;
                }
                values[currentOctet++] = (byte)currentValue;
                currentValue = 0;
                numDigits = 0;
                continue;
            }
            return null;
        }
        if (currentOctet != 3) {
            return null;
        }
        if (numDigits == 0) {
            return null;
        }
        values[currentOctet] = (byte)currentValue;
        return values;
    }

    private static byte[] parseV6(String s) {
        int i2;
        int range = -1;
        byte[] data = new byte[16];
        String[] tokens = s.split(":", -1);
        int first = 0;
        int last = tokens.length - 1;
        if (tokens[0].length() == 0) {
            if (last - first > 0 && tokens[1].length() == 0) {
                ++first;
            } else {
                return null;
            }
        }
        if (tokens[last].length() == 0) {
            if (last - first > 0 && tokens[last - 1].length() == 0) {
                --last;
            } else {
                return null;
            }
        }
        if (last - first + 1 > 8) {
            return null;
        }
        int j2 = 0;
        for (i2 = first; i2 <= last; ++i2) {
            if (tokens[i2].length() == 0) {
                if (range >= 0) {
                    return null;
                }
                range = j2;
                continue;
            }
            if (tokens[i2].indexOf(46) >= 0) {
                if (i2 < last) {
                    return null;
                }
                if (i2 > 6) {
                    return null;
                }
                byte[] v4addr = Address.toByteArray(tokens[i2], 1);
                if (v4addr == null) {
                    return null;
                }
                for (int k = 0; k < 4; ++k) {
                    data[j2++] = v4addr[k];
                }
                break;
            }
            try {
                for (int k = 0; k < tokens[i2].length(); ++k) {
                    char c2 = tokens[i2].charAt(k);
                    if (Character.digit(c2, 16) >= 0) continue;
                    return null;
                }
                int x = Integer.parseInt(tokens[i2], 16);
                if (x > 65535 || x < 0) {
                    return null;
                }
                data[j2++] = (byte)(x >>> 8);
                data[j2++] = (byte)(x & 0xFF);
                continue;
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
        if (j2 < 16 && range < 0) {
            return null;
        }
        if (range >= 0) {
            int empty = 16 - j2;
            System.arraycopy(data, range, data, range + empty, j2 - range);
            for (i2 = range; i2 < range + empty; ++i2) {
                data[i2] = 0;
            }
        }
        return data;
    }

    public static int[] toArray(String s, int family) {
        byte[] byteArray = Address.toByteArray(s, family);
        if (byteArray == null) {
            return null;
        }
        int[] intArray = new int[byteArray.length];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            intArray[i2] = byteArray[i2] & 0xFF;
        }
        return intArray;
    }

    public static int[] toArray(String s) {
        return Address.toArray(s, 1);
    }

    public static byte[] toByteArray(String s, int family) {
        if (family == 1) {
            return Address.parseV4(s);
        }
        if (family == 2) {
            return Address.parseV6(s);
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static boolean isDottedQuad(String s) {
        byte[] address = Address.toByteArray(s, 1);
        return address != null;
    }

    public static String toDottedQuad(byte[] addr) {
        return (addr[0] & 0xFF) + "." + (addr[1] & 0xFF) + "." + (addr[2] & 0xFF) + "." + (addr[3] & 0xFF);
    }

    public static String toDottedQuad(int[] addr) {
        return addr[0] + "." + addr[1] + "." + addr[2] + "." + addr[3];
    }

    private static Record[] lookupHostName(String name, boolean all) throws UnknownHostException {
        try {
            Lookup lookup2 = new Lookup(name, 1);
            Record[] a2 = lookup2.run();
            if (a2 == null) {
                Record[] aaaa;
                if (lookup2.getResult() == 4 && (aaaa = new Lookup(name, 28).run()) != null) {
                    return aaaa;
                }
                throw new UnknownHostException("unknown host");
            }
            if (!all) {
                return a2;
            }
            Record[] aaaa = new Lookup(name, 28).run();
            if (aaaa == null) {
                return a2;
            }
            Record[] merged = new Record[a2.length + aaaa.length];
            System.arraycopy(a2, 0, merged, 0, a2.length);
            System.arraycopy(aaaa, 0, merged, a2.length, aaaa.length);
            return merged;
        }
        catch (TextParseException e2) {
            throw new UnknownHostException("invalid name");
        }
    }

    private static InetAddress addrFromRecord(String name, Record r) throws UnknownHostException {
        InetAddress addr = r instanceof ARecord ? ((ARecord)r).getAddress() : ((AAAARecord)r).getAddress();
        return InetAddress.getByAddress(name, addr.getAddress());
    }

    public static InetAddress getByName(String name) throws UnknownHostException {
        try {
            return Address.getByAddress(name);
        }
        catch (UnknownHostException e2) {
            Record[] records = Address.lookupHostName(name, false);
            return Address.addrFromRecord(name, records[0]);
        }
    }

    public static InetAddress[] getAllByName(String name) throws UnknownHostException {
        try {
            InetAddress addr = Address.getByAddress(name);
            return new InetAddress[]{addr};
        }
        catch (UnknownHostException e2) {
            Record[] records = Address.lookupHostName(name, true);
            InetAddress[] addrs = new InetAddress[records.length];
            for (int i2 = 0; i2 < records.length; ++i2) {
                addrs[i2] = Address.addrFromRecord(name, records[i2]);
            }
            return addrs;
        }
    }

    public static InetAddress getByAddress(String addr) throws UnknownHostException {
        byte[] bytes = Address.toByteArray(addr, 1);
        if (bytes != null) {
            return InetAddress.getByAddress(addr, bytes);
        }
        bytes = Address.toByteArray(addr, 2);
        if (bytes != null) {
            return InetAddress.getByAddress(addr, bytes);
        }
        throw new UnknownHostException("Invalid address: " + addr);
    }

    public static InetAddress getByAddress(String addr, int family) throws UnknownHostException {
        if (family != 1 && family != 2) {
            throw new IllegalArgumentException("unknown address family");
        }
        byte[] bytes = Address.toByteArray(addr, family);
        if (bytes != null) {
            return InetAddress.getByAddress(addr, bytes);
        }
        throw new UnknownHostException("Invalid address: " + addr);
    }

    public static String getHostName(InetAddress addr) throws UnknownHostException {
        Name name = ReverseMap.fromAddress(addr);
        Record[] records = new Lookup(name, 12).run();
        if (records == null) {
            throw new UnknownHostException("unknown address");
        }
        PTRRecord ptr = (PTRRecord)records[0];
        return ptr.getTarget().toString();
    }

    public static int familyOf(InetAddress address) {
        if (address instanceof Inet4Address) {
            return 1;
        }
        if (address instanceof Inet6Address) {
            return 2;
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static int addressLength(int family) {
        if (family == 1) {
            return 4;
        }
        if (family == 2) {
            return 16;
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static InetAddress truncate(InetAddress address, int maskLength) {
        int family = Address.familyOf(address);
        int maxMaskLength = Address.addressLength(family) * 8;
        if (maskLength < 0 || maskLength > maxMaskLength) {
            throw new IllegalArgumentException("invalid mask length");
        }
        if (maskLength == maxMaskLength) {
            return address;
        }
        byte[] bytes = address.getAddress();
        for (int i2 = maskLength / 8 + 1; i2 < bytes.length; ++i2) {
            bytes[i2] = 0;
        }
        int maskBits = maskLength % 8;
        int bitmask = 0;
        for (int i3 = 0; i3 < maskBits; ++i3) {
            bitmask |= 1 << 7 - i3;
        }
        int n = maskLength / 8;
        bytes[n] = (byte)(bytes[n] & bitmask);
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e2) {
            throw new IllegalArgumentException("invalid address");
        }
    }
}

