/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class CAARecord
extends Record {
    private static final long serialVersionUID = 8544304287274216443L;
    private int flags;
    private byte[] tag;
    private byte[] value;

    CAARecord() {
    }

    Record getObject() {
        return new CAARecord();
    }

    public CAARecord(Name name, int dclass, long ttl, int flags, String tag, String value) {
        super(name, 257, dclass, ttl);
        this.flags = CAARecord.checkU8("flags", flags);
        try {
            this.tag = CAARecord.byteArrayFromString(tag);
            this.value = CAARecord.byteArrayFromString(value);
        }
        catch (TextParseException e2) {
            throw new IllegalArgumentException(e2.getMessage());
        }
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.flags = in.readU8();
        this.tag = in.readCountedString();
        this.value = in.readByteArray();
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.flags = st.getUInt8();
        try {
            this.tag = CAARecord.byteArrayFromString(st.getString());
            this.value = CAARecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e2) {
            throw st.exception(e2.getMessage());
        }
    }

    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.flags);
        sb.append(" ");
        sb.append(CAARecord.byteArrayToString(this.tag, false));
        sb.append(" ");
        sb.append(CAARecord.byteArrayToString(this.value, true));
        return sb.toString();
    }

    public int getFlags() {
        return this.flags;
    }

    public String getTag() {
        return CAARecord.byteArrayToString(this.tag, false);
    }

    public String getValue() {
        return CAARecord.byteArrayToString(this.value, false);
    }

    void rrToWire(DNSOutput out, Compression c2, boolean canonical) {
        out.writeU8(this.flags);
        out.writeCountedString(this.tag);
        out.writeByteArray(this.value);
    }

    public static class Flags {
        public static final int IssuerCritical = 128;

        private Flags() {
        }
    }
}

