/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

public class Generator {
    public long start;
    public long end;
    public long step;
    public final String namePattern;
    public final int type;
    public final int dclass;
    public final long ttl;
    public final String rdataPattern;
    public final Name origin;
    private long current;

    public static boolean supportedType(int type) {
        Type.check(type);
        return type == 12 || type == 5 || type == 39 || type == 1 || type == 28 || type == 2;
    }

    public Generator(long start, long end, long step, String namePattern, int type, int dclass, long ttl, String rdataPattern, Name origin) {
        if (start < 0L || end < 0L || start > end || step <= 0L) {
            throw new IllegalArgumentException("invalid range specification");
        }
        if (!Generator.supportedType(type)) {
            throw new IllegalArgumentException("unsupported type");
        }
        DClass.check(dclass);
        this.start = start;
        this.end = end;
        this.step = step;
        this.namePattern = namePattern;
        this.type = type;
        this.dclass = dclass;
        this.ttl = ttl;
        this.rdataPattern = rdataPattern;
        this.origin = origin;
        this.current = start;
    }

    private String substitute(String spec, long n) throws IOException {
        boolean escaped = false;
        byte[] str = spec.getBytes();
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < str.length; ++i2) {
            char c2 = (char)(str[i2] & 0xFF);
            if (escaped) {
                sb.append(c2);
                escaped = false;
                continue;
            }
            if (c2 == '\\') {
                if (i2 + 1 == str.length) {
                    throw new TextParseException("invalid escape character");
                }
                escaped = true;
                continue;
            }
            if (c2 == '$') {
                long v;
                boolean negative = false;
                long offset = 0L;
                long width = 0L;
                long base = 10L;
                boolean wantUpperCase = false;
                if (i2 + 1 < str.length && str[i2 + 1] == 36) {
                    c2 = (char)(str[++i2] & 0xFF);
                    sb.append(c2);
                    continue;
                }
                if (i2 + 1 < str.length && str[i2 + 1] == 123) {
                    if (++i2 + 1 < str.length && str[i2 + 1] == 45) {
                        negative = true;
                        ++i2;
                    }
                    while (i2 + 1 < str.length && (c2 = (char)(str[++i2] & 0xFF)) != ',' && c2 != '}') {
                        if (c2 < '0' || c2 > '9') {
                            throw new TextParseException("invalid offset");
                        }
                        c2 = (char)(c2 - 48);
                        offset *= 10L;
                        offset += (long)c2;
                    }
                    if (negative) {
                        offset = -offset;
                    }
                    if (c2 == ',') {
                        while (i2 + 1 < str.length && (c2 = (char)(str[++i2] & 0xFF)) != ',' && c2 != '}') {
                            if (c2 < '0' || c2 > '9') {
                                throw new TextParseException("invalid width");
                            }
                            c2 = (char)(c2 - 48);
                            width *= 10L;
                            width += (long)c2;
                        }
                    }
                    if (c2 == ',') {
                        if (i2 + 1 == str.length) {
                            throw new TextParseException("invalid base");
                        }
                        if ((c2 = (char)(str[++i2] & 0xFF)) == 'o') {
                            base = 8L;
                        } else if (c2 == 'x') {
                            base = 16L;
                        } else if (c2 == 'X') {
                            base = 16L;
                            wantUpperCase = true;
                        } else if (c2 != 'd') {
                            throw new TextParseException("invalid base");
                        }
                    }
                    if (i2 + 1 == str.length || str[i2 + 1] != 125) {
                        throw new TextParseException("invalid modifiers");
                    }
                    ++i2;
                }
                if ((v = n + offset) < 0L) {
                    throw new TextParseException("invalid offset expansion");
                }
                String number = base == 8L ? Long.toOctalString(v) : (base == 16L ? Long.toHexString(v) : Long.toString(v));
                if (wantUpperCase) {
                    number = number.toUpperCase();
                }
                if (width != 0L && width > (long)number.length()) {
                    int zeros = (int)width - number.length();
                    while (zeros-- > 0) {
                        sb.append('0');
                    }
                }
                sb.append(number);
                continue;
            }
            sb.append(c2);
        }
        return sb.toString();
    }

    public Record nextRecord() throws IOException {
        if (this.current > this.end) {
            return null;
        }
        String namestr = this.substitute(this.namePattern, this.current);
        Name name = Name.fromString(namestr, this.origin);
        String rdata = this.substitute(this.rdataPattern, this.current);
        this.current += this.step;
        return Record.fromString(name, this.type, this.dclass, this.ttl, rdata, this.origin);
    }

    public Record[] expand() throws IOException {
        ArrayList<Record> list = new ArrayList<Record>();
        for (long i2 = this.start; i2 < this.end; i2 += this.step) {
            String namestr = this.substitute(this.namePattern, this.current);
            Name name = Name.fromString(namestr, this.origin);
            String rdata = this.substitute(this.rdataPattern, this.current);
            list.add(Record.fromString(name, this.type, this.dclass, this.ttl, rdata, this.origin));
        }
        return list.toArray(new Record[list.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("$GENERATE ");
        sb.append(this.start + "-" + this.end);
        if (this.step > 1L) {
            sb.append("/" + this.step);
        }
        sb.append(" ");
        sb.append(this.namePattern + " ");
        sb.append(this.ttl + " ");
        if (this.dclass != 1 || !Options.check("noPrintIN")) {
            sb.append(DClass.string(this.dclass) + " ");
        }
        sb.append(Type.string(this.type) + " ");
        sb.append(this.rdataPattern + " ");
        return sb.toString();
    }
}

