/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Header;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.Section;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Update;
import org.xbill.DNS.WireParseException;

public class Message
implements Cloneable {
    public static final int MAXLENGTH = 65535;
    private Header header;
    private List[] sections;
    private int size;
    private TSIG tsigkey;
    private TSIGRecord querytsig;
    private int tsigerror;
    int tsigstart;
    int tsigState;
    int sig0start;
    static final int TSIG_UNSIGNED = 0;
    static final int TSIG_VERIFIED = 1;
    static final int TSIG_INTERMEDIATE = 2;
    static final int TSIG_SIGNED = 3;
    static final int TSIG_FAILED = 4;
    private static Record[] emptyRecordArray = new Record[0];
    private static RRset[] emptyRRsetArray = new RRset[0];

    private Message(Header header) {
        this.sections = new List[4];
        this.header = header;
    }

    public Message(int id) {
        this(new Header(id));
    }

    public Message() {
        this(new Header());
    }

    public static Message newQuery(Record r) {
        Message m = new Message();
        m.header.setOpcode(0);
        m.header.setFlag(7);
        m.addRecord(r, 0);
        return m;
    }

    public static Message newUpdate(Name zone) {
        return new Update(zone);
    }

    Message(DNSInput in) throws IOException {
        block6: {
            this(new Header(in));
            boolean isUpdate = this.header.getOpcode() == 5;
            boolean truncated = this.header.getFlag(6);
            try {
                for (int i2 = 0; i2 < 4; ++i2) {
                    int count = this.header.getCount(i2);
                    if (count > 0) {
                        this.sections[i2] = new ArrayList(count);
                    }
                    for (int j2 = 0; j2 < count; ++j2) {
                        SIGRecord sig;
                        int pos = in.current();
                        Record rec = Record.fromWire(in, i2, isUpdate);
                        this.sections[i2].add(rec);
                        if (i2 != 3) continue;
                        if (rec.getType() == 250) {
                            this.tsigstart = pos;
                        }
                        if (rec.getType() != 24 || (sig = (SIGRecord)rec).getTypeCovered() != 0) continue;
                        this.sig0start = pos;
                    }
                }
            }
            catch (WireParseException e2) {
                if (truncated) break block6;
                throw e2;
            }
        }
        this.size = in.current();
    }

    public Message(byte[] b2) throws IOException {
        this(new DNSInput(b2));
    }

    public Message(ByteBuffer byteBuffer) throws IOException {
        this(new DNSInput(byteBuffer));
    }

    public void setHeader(Header h2) {
        this.header = h2;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addRecord(Record r, int section) {
        if (this.sections[section] == null) {
            this.sections[section] = new LinkedList();
        }
        this.header.incCount(section);
        this.sections[section].add(r);
    }

    public boolean removeRecord(Record r, int section) {
        if (this.sections[section] != null && this.sections[section].remove(r)) {
            this.header.decCount(section);
            return true;
        }
        return false;
    }

    public void removeAllRecords(int section) {
        this.sections[section] = null;
        this.header.setCount(section, 0);
    }

    public boolean findRecord(Record r, int section) {
        return this.sections[section] != null && this.sections[section].contains(r);
    }

    public boolean findRecord(Record r) {
        for (int i2 = 1; i2 <= 3; ++i2) {
            if (this.sections[i2] == null || !this.sections[i2].contains(r)) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int type, int section) {
        if (this.sections[section] == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.sections[section].size(); ++i2) {
            Record r = (Record)this.sections[section].get(i2);
            if (r.getType() != type || !name.equals(r.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int type) {
        return this.findRRset(name, type, 1) || this.findRRset(name, type, 2) || this.findRRset(name, type, 3);
    }

    public Record getQuestion() {
        List l = this.sections[0];
        if (l == null || l.size() == 0) {
            return null;
        }
        return (Record)l.get(0);
    }

    public TSIGRecord getTSIG() {
        int count = this.header.getCount(3);
        if (count == 0) {
            return null;
        }
        List l = this.sections[3];
        Record rec = (Record)l.get(count - 1);
        if (rec.type != 250) {
            return null;
        }
        return (TSIGRecord)rec;
    }

    public boolean isSigned() {
        return this.tsigState == 3 || this.tsigState == 1 || this.tsigState == 4;
    }

    public boolean isVerified() {
        return this.tsigState == 1;
    }

    public OPTRecord getOPT() {
        Record[] additional = this.getSectionArray(3);
        for (int i2 = 0; i2 < additional.length; ++i2) {
            if (!(additional[i2] instanceof OPTRecord)) continue;
            return (OPTRecord)additional[i2];
        }
        return null;
    }

    public int getRcode() {
        int rcode = this.header.getRcode();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            rcode += opt.getExtendedRcode() << 4;
        }
        return rcode;
    }

    public Record[] getSectionArray(int section) {
        if (this.sections[section] == null) {
            return emptyRecordArray;
        }
        List l = this.sections[section];
        return l.toArray(new Record[l.size()]);
    }

    private static boolean sameSet(Record r1, Record r2) {
        return r1.getRRsetType() == r2.getRRsetType() && r1.getDClass() == r2.getDClass() && r1.getName().equals(r2.getName());
    }

    public RRset[] getSectionRRsets(int section) {
        if (this.sections[section] == null) {
            return emptyRRsetArray;
        }
        LinkedList<RRset> sets = new LinkedList<RRset>();
        Record[] recs = this.getSectionArray(section);
        HashSet<Name> hash = new HashSet<Name>();
        for (int i2 = 0; i2 < recs.length; ++i2) {
            Name name = recs[i2].getName();
            boolean newset = true;
            if (hash.contains(name)) {
                for (int j2 = sets.size() - 1; j2 >= 0; --j2) {
                    RRset set = (RRset)sets.get(j2);
                    if (set.getType() != recs[i2].getRRsetType() || set.getDClass() != recs[i2].getDClass() || !set.getName().equals(name)) continue;
                    set.addRR(recs[i2]);
                    newset = false;
                    break;
                }
            }
            if (!newset) continue;
            RRset set = new RRset(recs[i2]);
            sets.add(set);
            hash.add(name);
        }
        return sets.toArray(new RRset[sets.size()]);
    }

    void toWire(DNSOutput out) {
        this.header.toWire(out);
        Compression c2 = new Compression();
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.sections[i2] == null) continue;
            for (int j2 = 0; j2 < this.sections[i2].size(); ++j2) {
                Record rec = (Record)this.sections[i2].get(j2);
                rec.toWire(out, i2, c2);
            }
        }
    }

    private int sectionToWire(DNSOutput out, int section, Compression c2, int maxLength) {
        int n = this.sections[section].size();
        int pos = out.current();
        int rendered = 0;
        int skipped = 0;
        Record lastrec = null;
        for (int i2 = 0; i2 < n; ++i2) {
            Record rec = (Record)this.sections[section].get(i2);
            if (section == 3 && rec instanceof OPTRecord) {
                ++skipped;
                continue;
            }
            if (lastrec != null && !Message.sameSet(rec, lastrec)) {
                pos = out.current();
                rendered = i2;
            }
            lastrec = rec;
            rec.toWire(out, section, c2);
            if (out.current() <= maxLength) continue;
            out.jump(pos);
            return n - rendered + skipped;
        }
        return skipped;
    }

    private boolean toWire(DNSOutput out, int maxLength) {
        if (maxLength < 12) {
            return false;
        }
        Object newheader = null;
        int tempMaxLength = maxLength;
        if (this.tsigkey != null) {
            tempMaxLength -= this.tsigkey.recordLength();
        }
        OPTRecord opt = this.getOPT();
        byte[] optBytes = null;
        if (opt != null) {
            optBytes = opt.toWire(3);
            tempMaxLength -= optBytes.length;
        }
        int startpos = out.current();
        this.header.toWire(out);
        Compression c2 = new Compression();
        int flags = this.header.getFlagsByte();
        int additionalCount = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.sections[i2] == null) continue;
            int skipped = this.sectionToWire(out, i2, c2, tempMaxLength);
            if (skipped != 0 && i2 != 3) {
                flags = Header.setFlag(flags, 6, true);
                out.writeU16At(this.header.getCount(i2) - skipped, startpos + 4 + 2 * i2);
                for (int j2 = i2 + 1; j2 < 3; ++j2) {
                    out.writeU16At(0, startpos + 4 + 2 * j2);
                }
                break;
            }
            if (i2 != 3) continue;
            additionalCount = this.header.getCount(i2) - skipped;
        }
        if (optBytes != null) {
            out.writeByteArray(optBytes);
            ++additionalCount;
        }
        if (flags != this.header.getFlagsByte()) {
            out.writeU16At(flags, startpos + 2);
        }
        if (additionalCount != this.header.getCount(3)) {
            out.writeU16At(additionalCount, startpos + 10);
        }
        if (this.tsigkey != null) {
            TSIGRecord tsigrec = this.tsigkey.generate(this, out.toByteArray(), this.tsigerror, this.querytsig);
            tsigrec.toWire(out, 3, c2);
            out.writeU16At(additionalCount + 1, startpos + 10);
        }
        return true;
    }

    public byte[] toWire() {
        DNSOutput out = new DNSOutput();
        this.toWire(out);
        this.size = out.current();
        return out.toByteArray();
    }

    public byte[] toWire(int maxLength) {
        DNSOutput out = new DNSOutput();
        this.toWire(out, maxLength);
        this.size = out.current();
        return out.toByteArray();
    }

    public void setTSIG(TSIG key, int error, TSIGRecord querytsig) {
        this.tsigkey = key;
        this.tsigerror = error;
        this.querytsig = querytsig;
    }

    public int numBytes() {
        return this.size;
    }

    public String sectionToString(int i2) {
        if (i2 > 3) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Record[] records = this.getSectionArray(i2);
        for (int j2 = 0; j2 < records.length; ++j2) {
            Record rec = records[j2];
            if (i2 == 0) {
                sb.append(";;\t" + rec.name);
                sb.append(", type = " + Type.string(rec.type));
                sb.append(", class = " + DClass.string(rec.dclass));
            } else {
                sb.append(rec);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            sb.append(this.header.toStringWithRcode(this.getRcode()) + "\n");
        } else {
            sb.append(this.header + "\n");
        }
        if (this.isSigned()) {
            sb.append(";; TSIG ");
            if (this.isVerified()) {
                sb.append("ok");
            } else {
                sb.append("invalid");
            }
            sb.append('\n');
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.header.getOpcode() != 5) {
                sb.append(";; " + Section.longString(i2) + ":\n");
            } else {
                sb.append(";; " + Section.updString(i2) + ":\n");
            }
            sb.append(this.sectionToString(i2) + "\n");
        }
        sb.append(";; Message size: " + this.numBytes() + " bytes");
        return sb.toString();
    }

    public Object clone() {
        Message m = new Message();
        for (int i2 = 0; i2 < this.sections.length; ++i2) {
            if (this.sections[i2] == null) continue;
            m.sections[i2] = new LinkedList(this.sections[i2]);
        }
        m.header = (Header)this.header.clone();
        m.size = this.size;
        return m;
    }
}

