/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.BitSet;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;

public class NXTRecord
extends Record {
    private static final long serialVersionUID = -8851454400765507520L;
    private Name next;
    private BitSet bitmap;

    NXTRecord() {
    }

    Record getObject() {
        return new NXTRecord();
    }

    public NXTRecord(Name name, int dclass, long ttl, Name next, BitSet bitmap) {
        super(name, 30, dclass, ttl);
        this.next = NXTRecord.checkName("next", next);
        this.bitmap = bitmap;
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.next = new Name(in);
        this.bitmap = new BitSet();
        int bitmapLength = in.remaining();
        for (int i2 = 0; i2 < bitmapLength; ++i2) {
            int t = in.readU8();
            for (int j2 = 0; j2 < 8; ++j2) {
                if ((t & 1 << 7 - j2) == 0) continue;
                this.bitmap.set(i2 * 8 + j2);
            }
        }
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        Tokenizer.Token t;
        this.next = st.getName(origin);
        this.bitmap = new BitSet();
        while ((t = st.get()).isString()) {
            int typecode = Type.value(t.value, true);
            if (typecode <= 0 || typecode > 128) {
                throw st.exception("Invalid type: " + t.value);
            }
            this.bitmap.set(typecode);
        }
        st.unget();
    }

    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.next);
        int length = this.bitmap.length();
        for (int i2 = 0; i2 < length; i2 = (int)((short)(i2 + 1))) {
            if (!this.bitmap.get(i2)) continue;
            sb.append(" ");
            sb.append(Type.string(i2));
        }
        return sb.toString();
    }

    public Name getNext() {
        return this.next;
    }

    public BitSet getBitmap() {
        return this.bitmap;
    }

    void rrToWire(DNSOutput out, Compression c2, boolean canonical) {
        this.next.toWire(out, null, canonical);
        int length = this.bitmap.length();
        int t = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            t |= this.bitmap.get(i2) ? 1 << 7 - i2 % 8 : 0;
            if (i2 % 8 != 7 && i2 != length - 1) continue;
            out.writeU8(t);
            t = 0;
        }
    }
}

