/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.WireParseException;

public class Name
implements Comparable,
Serializable {
    private static final long serialVersionUID = -7257019940971525644L;
    private static final int LABEL_NORMAL = 0;
    private static final int LABEL_COMPRESSION = 192;
    private static final int LABEL_MASK = 192;
    private byte[] name;
    private long offsets;
    private int hashcode;
    private static final byte[] emptyLabel = new byte[]{0};
    private static final byte[] wildLabel = new byte[]{1, 42};
    public static final Name root;
    public static final Name empty;
    private static final int MAXNAME = 255;
    private static final int MAXLABEL = 63;
    private static final int MAXLABELS = 128;
    private static final int MAXOFFSETS = 7;
    private static final DecimalFormat byteFormat;
    private static final byte[] lowercase;
    private static final Name wild;

    private Name() {
    }

    private final void setoffset(int n, int offset) {
        if (n >= 7) {
            return;
        }
        int shift = 8 * (7 - n);
        this.offsets &= 255L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        this.offsets |= (long)offset << shift;
    }

    private final int offset(int n) {
        if (n == 0 && this.getlabels() == 0) {
            return 0;
        }
        if (n < 0 || n >= this.getlabels()) {
            throw new IllegalArgumentException("label out of range");
        }
        if (n < 7) {
            int shift = 8 * (7 - n);
            return (int)(this.offsets >>> shift) & 0xFF;
        }
        int pos = this.offset(6);
        for (int i2 = 6; i2 < n; ++i2) {
            pos += this.name[pos] + 1;
        }
        return pos;
    }

    private final void setlabels(int labels) {
        this.offsets &= 0xFFFFFFFFFFFFFF00L;
        this.offsets |= (long)labels;
    }

    private final int getlabels() {
        return (int)(this.offsets & 0xFFL);
    }

    private static final void copy(Name src, Name dst) {
        if (src.offset(0) == 0) {
            dst.name = src.name;
            dst.offsets = src.offsets;
        } else {
            int offset0 = src.offset(0);
            int namelen = src.name.length - offset0;
            int labels = src.labels();
            dst.name = new byte[namelen];
            System.arraycopy(src.name, offset0, dst.name, 0, namelen);
            for (int i2 = 0; i2 < labels && i2 < 7; ++i2) {
                dst.setoffset(i2, src.offset(i2) - offset0);
            }
            dst.setlabels(labels);
        }
    }

    private final void append(byte[] array, int start, int n) throws NameTooLongException {
        int length = this.name == null ? 0 : this.name.length - this.offset(0);
        int alength = 0;
        int pos = start;
        for (int i2 = 0; i2 < n; ++i2) {
            int len = array[pos];
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            pos += ++len;
            alength += len;
        }
        int newlength = length + alength;
        if (newlength > 255) {
            throw new NameTooLongException();
        }
        int labels = this.getlabels();
        int newlabels = labels + n;
        if (newlabels > 128) {
            throw new IllegalStateException("too many labels");
        }
        byte[] newname = new byte[newlength];
        if (length != 0) {
            System.arraycopy(this.name, this.offset(0), newname, 0, length);
        }
        System.arraycopy(array, start, newname, length, alength);
        this.name = newname;
        int pos2 = length;
        for (int i3 = 0; i3 < n; ++i3) {
            this.setoffset(labels + i3, pos2);
            pos2 += newname[pos2] + 1;
        }
        this.setlabels(newlabels);
    }

    private static TextParseException parseException(String str, String message) {
        return new TextParseException("'" + str + "': " + message);
    }

    private final void appendFromString(String fullName, byte[] array, int start, int n) throws TextParseException {
        try {
            this.append(array, start, n);
        }
        catch (NameTooLongException e2) {
            throw Name.parseException(fullName, "Name too long");
        }
    }

    private final void appendSafe(byte[] array, int start, int n) {
        try {
            this.append(array, start, n);
        }
        catch (NameTooLongException nameTooLongException) {
            // empty catch block
        }
    }

    public Name(String s, Name origin) throws TextParseException {
        if (s.equals("")) {
            throw Name.parseException(s, "empty name");
        }
        if (s.equals("@")) {
            if (origin == null) {
                Name.copy(empty, this);
            } else {
                Name.copy(origin, this);
            }
            return;
        }
        if (s.equals(".")) {
            Name.copy(root, this);
            return;
        }
        int labelstart = -1;
        int pos = 1;
        byte[] label = new byte[64];
        boolean escaped = false;
        int digits = 0;
        int intval = 0;
        boolean absolute = false;
        for (int i2 = 0; i2 < s.length(); ++i2) {
            byte b2 = (byte)s.charAt(i2);
            if (escaped) {
                if (b2 >= 48 && b2 <= 57 && digits < 3) {
                    ++digits;
                    intval *= 10;
                    if ((intval += b2 - 48) > 255) {
                        throw Name.parseException(s, "bad escape");
                    }
                    if (digits < 3) continue;
                    b2 = (byte)intval;
                } else if (digits > 0 && digits < 3) {
                    throw Name.parseException(s, "bad escape");
                }
                if (pos > 63) {
                    throw Name.parseException(s, "label too long");
                }
                labelstart = pos;
                label[pos++] = b2;
                escaped = false;
                continue;
            }
            if (b2 == 92) {
                escaped = true;
                digits = 0;
                intval = 0;
                continue;
            }
            if (b2 == 46) {
                if (labelstart == -1) {
                    throw Name.parseException(s, "invalid empty label");
                }
                label[0] = (byte)(pos - 1);
                this.appendFromString(s, label, 0, 1);
                labelstart = -1;
                pos = 1;
                continue;
            }
            if (labelstart == -1) {
                labelstart = i2;
            }
            if (pos > 63) {
                throw Name.parseException(s, "label too long");
            }
            label[pos++] = b2;
        }
        if (digits > 0 && digits < 3) {
            throw Name.parseException(s, "bad escape");
        }
        if (escaped) {
            throw Name.parseException(s, "bad escape");
        }
        if (labelstart == -1) {
            this.appendFromString(s, emptyLabel, 0, 1);
            absolute = true;
        } else {
            label[0] = (byte)(pos - 1);
            this.appendFromString(s, label, 0, 1);
        }
        if (origin != null && !absolute) {
            this.appendFromString(s, origin.name, origin.offset(0), origin.getlabels());
        }
    }

    public Name(String s) throws TextParseException {
        this(s, null);
    }

    public static Name fromString(String s, Name origin) throws TextParseException {
        if (s.equals("@") && origin != null) {
            return origin;
        }
        if (s.equals(".")) {
            return root;
        }
        return new Name(s, origin);
    }

    public static Name fromString(String s) throws TextParseException {
        return Name.fromString(s, null);
    }

    public static Name fromConstantString(String s) {
        try {
            return Name.fromString(s, null);
        }
        catch (TextParseException e2) {
            throw new IllegalArgumentException("Invalid name '" + s + "'");
        }
    }

    public Name(DNSInput in) throws WireParseException {
        boolean done = false;
        byte[] label = new byte[64];
        boolean savedState = false;
        block4: while (!done) {
            int len = in.readU8();
            switch (len & 0xC0) {
                case 0: {
                    if (this.getlabels() >= 128) {
                        throw new WireParseException("too many labels");
                    }
                    if (len == 0) {
                        this.append(emptyLabel, 0, 1);
                        done = true;
                        continue block4;
                    }
                    label[0] = (byte)len;
                    in.readByteArray(label, 1, len);
                    this.append(label, 0, 1);
                    continue block4;
                }
                case 192: {
                    int pos = in.readU8();
                    pos += (len & 0xFFFFFF3F) << 8;
                    if (Options.check("verbosecompression")) {
                        System.err.println("currently " + in.current() + ", pointer to " + pos);
                    }
                    if (pos >= in.current() - 2) {
                        throw new WireParseException("bad compression");
                    }
                    if (!savedState) {
                        in.save();
                        savedState = true;
                    }
                    in.jump(pos);
                    if (!Options.check("verbosecompression")) continue block4;
                    System.err.println("current name '" + this + "', seeking to " + pos);
                    continue block4;
                }
            }
            throw new WireParseException("bad label type");
        }
        if (savedState) {
            in.restore();
        }
    }

    public Name(byte[] b2) throws IOException {
        this(new DNSInput(b2));
    }

    public Name(Name src, int n) {
        int slabels = src.labels();
        if (n > slabels) {
            throw new IllegalArgumentException("attempted to remove too many labels");
        }
        this.name = src.name;
        this.setlabels(slabels - n);
        for (int i2 = 0; i2 < 7 && i2 < slabels - n; ++i2) {
            this.setoffset(i2, src.offset(i2 + n));
        }
    }

    public static Name concatenate(Name prefix, Name suffix) throws NameTooLongException {
        if (prefix.isAbsolute()) {
            return prefix;
        }
        Name newname = new Name();
        Name.copy(prefix, newname);
        newname.append(suffix.name, suffix.offset(0), suffix.getlabels());
        return newname;
    }

    public Name relativize(Name origin) {
        if (origin == null || !this.subdomain(origin)) {
            return this;
        }
        Name newname = new Name();
        Name.copy(this, newname);
        int length = this.length() - origin.length();
        int labels = newname.labels() - origin.labels();
        newname.setlabels(labels);
        newname.name = new byte[length];
        System.arraycopy(this.name, this.offset(0), newname.name, 0, length);
        return newname;
    }

    public Name wild(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("must replace 1 or more labels");
        }
        try {
            Name newname = new Name();
            Name.copy(wild, newname);
            newname.append(this.name, this.offset(n), this.getlabels() - n);
            return newname;
        }
        catch (NameTooLongException e2) {
            throw new IllegalStateException("Name.wild: concatenate failed");
        }
    }

    public Name canonicalize() {
        boolean canonical = true;
        for (int i2 = 0; i2 < this.name.length; ++i2) {
            if (lowercase[this.name[i2] & 0xFF] == this.name[i2]) continue;
            canonical = false;
            break;
        }
        if (canonical) {
            return this;
        }
        Name newname = new Name();
        newname.appendSafe(this.name, this.offset(0), this.getlabels());
        for (int i3 = 0; i3 < newname.name.length; ++i3) {
            newname.name[i3] = lowercase[newname.name[i3] & 0xFF];
        }
        return newname;
    }

    public Name fromDNAME(DNAMERecord dname) throws NameTooLongException {
        Name dnameowner = dname.getName();
        Name dnametarget = dname.getTarget();
        if (!this.subdomain(dnameowner)) {
            return null;
        }
        int plabels = this.labels() - dnameowner.labels();
        int plength = this.length() - dnameowner.length();
        int pstart = this.offset(0);
        int dlabels = dnametarget.labels();
        short dlength = dnametarget.length();
        if (plength + dlength > 255) {
            throw new NameTooLongException();
        }
        Name newname = new Name();
        newname.setlabels(plabels + dlabels);
        newname.name = new byte[plength + dlength];
        System.arraycopy(this.name, pstart, newname.name, 0, plength);
        System.arraycopy(dnametarget.name, 0, newname.name, plength, dlength);
        int pos = 0;
        for (int i2 = 0; i2 < 7 && i2 < plabels + dlabels; ++i2) {
            newname.setoffset(i2, pos);
            pos += newname.name[pos] + 1;
        }
        return newname;
    }

    public boolean isWild() {
        if (this.labels() == 0) {
            return false;
        }
        return this.name[0] == 1 && this.name[1] == 42;
    }

    public boolean isAbsolute() {
        int nlabels = this.labels();
        if (nlabels == 0) {
            return false;
        }
        return this.name[this.offset(nlabels - 1)] == 0;
    }

    public short length() {
        if (this.getlabels() == 0) {
            return 0;
        }
        return (short)(this.name.length - this.offset(0));
    }

    public int labels() {
        return this.getlabels();
    }

    public boolean subdomain(Name domain) {
        int labels = this.labels();
        int dlabels = domain.labels();
        if (dlabels > labels) {
            return false;
        }
        if (dlabels == labels) {
            return this.equals(domain);
        }
        return domain.equals(this.name, this.offset(labels - dlabels));
    }

    private String byteString(byte[] array, int pos) {
        StringBuffer sb = new StringBuffer();
        byte len = array[pos++];
        for (int i2 = pos; i2 < pos + len; ++i2) {
            int b2 = array[i2] & 0xFF;
            if (b2 <= 32 || b2 >= 127) {
                sb.append('\\');
                sb.append(byteFormat.format(b2));
                continue;
            }
            if (b2 == 34 || b2 == 40 || b2 == 41 || b2 == 46 || b2 == 59 || b2 == 92 || b2 == 64 || b2 == 36) {
                sb.append('\\');
                sb.append((char)b2);
                continue;
            }
            sb.append((char)b2);
        }
        return sb.toString();
    }

    public String toString(boolean omitFinalDot) {
        int labels = this.labels();
        if (labels == 0) {
            return "@";
        }
        if (labels == 1 && this.name[this.offset(0)] == 0) {
            return ".";
        }
        StringBuffer sb = new StringBuffer();
        int pos = this.offset(0);
        for (int i2 = 0; i2 < labels; ++i2) {
            byte len = this.name[pos];
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            if (len == 0) {
                if (omitFinalDot) break;
                sb.append('.');
                break;
            }
            if (i2 > 0) {
                sb.append('.');
            }
            sb.append(this.byteString(this.name, pos));
            pos += 1 + len;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] getLabel(int n) {
        int pos = this.offset(n);
        byte len = (byte)(this.name[pos] + 1);
        byte[] label = new byte[len];
        System.arraycopy(this.name, pos, label, 0, len);
        return label;
    }

    public String getLabelString(int n) {
        int pos = this.offset(n);
        return this.byteString(this.name, pos);
    }

    public void toWire(DNSOutput out, Compression c2) {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("toWire() called on non-absolute name");
        }
        int labels = this.labels();
        for (int i2 = 0; i2 < labels - 1; ++i2) {
            Name tname = i2 == 0 ? this : new Name(this, i2);
            int pos = -1;
            if (c2 != null) {
                pos = c2.get(tname);
            }
            if (pos >= 0) {
                out.writeU16(pos |= 0xC000);
                return;
            }
            if (c2 != null) {
                c2.add(out.current(), tname);
            }
            int off = this.offset(i2);
            out.writeByteArray(this.name, off, this.name[off] + 1);
        }
        out.writeU8(0);
    }

    public byte[] toWire() {
        DNSOutput out = new DNSOutput();
        this.toWire(out, null);
        return out.toByteArray();
    }

    public void toWireCanonical(DNSOutput out) {
        byte[] b2 = this.toWireCanonical();
        out.writeByteArray(b2);
    }

    public byte[] toWireCanonical() {
        int labels = this.labels();
        if (labels == 0) {
            return new byte[0];
        }
        byte[] b2 = new byte[this.name.length - this.offset(0)];
        int spos = this.offset(0);
        int dpos = 0;
        for (int i2 = 0; i2 < labels; ++i2) {
            int len = this.name[spos];
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            b2[dpos++] = this.name[spos++];
            for (int j2 = 0; j2 < len; ++j2) {
                b2[dpos++] = lowercase[this.name[spos++] & 0xFF];
            }
        }
        return b2;
    }

    public void toWire(DNSOutput out, Compression c2, boolean canonical) {
        if (canonical) {
            this.toWireCanonical(out);
        } else {
            this.toWire(out, c2);
        }
    }

    private final boolean equals(byte[] b2, int bpos) {
        int labels = this.labels();
        int pos = this.offset(0);
        for (int i2 = 0; i2 < labels; ++i2) {
            if (this.name[pos] != b2[bpos]) {
                return false;
            }
            int len = this.name[pos++];
            ++bpos;
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            for (int j2 = 0; j2 < len; ++j2) {
                if (lowercase[this.name[pos++] & 0xFF] == lowercase[b2[bpos++] & 0xFF]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null || !(arg instanceof Name)) {
            return false;
        }
        Name d2 = (Name)arg;
        if (d2.hashcode == 0) {
            d2.hashCode();
        }
        if (this.hashcode == 0) {
            this.hashCode();
        }
        if (d2.hashcode != this.hashcode) {
            return false;
        }
        if (d2.labels() != this.labels()) {
            return false;
        }
        return this.equals(d2.name, d2.offset(0));
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        int code = 0;
        for (int i2 = this.offset(0); i2 < this.name.length; ++i2) {
            code += (code << 3) + lowercase[this.name[i2] & 0xFF];
        }
        this.hashcode = code;
        return this.hashcode;
    }

    public int compareTo(Object o) {
        int alabels;
        Name arg = (Name)o;
        if (this == arg) {
            return 0;
        }
        int labels = this.labels();
        int compares = labels > (alabels = arg.labels()) ? alabels : labels;
        for (int i2 = 1; i2 <= compares; ++i2) {
            int start = this.offset(labels - i2);
            int astart = arg.offset(alabels - i2);
            int length = this.name[start];
            byte alength = arg.name[astart];
            for (int j2 = 0; j2 < length && j2 < alength; ++j2) {
                int n = lowercase[this.name[j2 + start + 1] & 0xFF] - lowercase[arg.name[j2 + astart + 1] & 0xFF];
                if (n == 0) continue;
                return n;
            }
            if (length == alength) continue;
            return length - alength;
        }
        return labels - alabels;
    }

    static {
        byteFormat = new DecimalFormat();
        lowercase = new byte[256];
        byteFormat.setMinimumIntegerDigits(3);
        for (int i2 = 0; i2 < lowercase.length; ++i2) {
            Name.lowercase[i2] = i2 < 65 || i2 > 90 ? (byte)i2 : (byte)(i2 - 65 + 97);
        }
        root = new Name();
        root.appendSafe(emptyLabel, 0, 1);
        empty = new Name();
        Name.empty.name = new byte[0];
        wild = new Name();
        wild.appendSafe(wildLabel, 0, 1);
    }
}

