/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class OPTRecord
extends Record {
    private static final long serialVersionUID = -6254521894809367938L;
    private List options;

    OPTRecord() {
    }

    Record getObject() {
        return new OPTRecord();
    }

    public OPTRecord(int payloadSize, int xrcode, int version, int flags, List options) {
        super(Name.root, 41, payloadSize, 0L);
        OPTRecord.checkU16("payloadSize", payloadSize);
        OPTRecord.checkU8("xrcode", xrcode);
        OPTRecord.checkU8("version", version);
        OPTRecord.checkU16("flags", flags);
        this.ttl = ((long)xrcode << 24) + ((long)version << 16) + (long)flags;
        if (options != null) {
            this.options = new ArrayList(options);
        }
    }

    public OPTRecord(int payloadSize, int xrcode, int version, int flags) {
        this(payloadSize, xrcode, version, flags, null);
    }

    public OPTRecord(int payloadSize, int xrcode, int version) {
        this(payloadSize, xrcode, version, 0, null);
    }

    void rrFromWire(DNSInput in) throws IOException {
        if (in.remaining() > 0) {
            this.options = new ArrayList();
        }
        while (in.remaining() > 0) {
            EDNSOption option = EDNSOption.fromWire(in);
            this.options.add(option);
        }
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        throw st.exception("no text format defined for OPT");
    }

    String rrToString() {
        StringBuffer sb = new StringBuffer();
        if (this.options != null) {
            sb.append(this.options);
            sb.append(" ");
        }
        sb.append(" ; payload ");
        sb.append(this.getPayloadSize());
        sb.append(", xrcode ");
        sb.append(this.getExtendedRcode());
        sb.append(", version ");
        sb.append(this.getVersion());
        sb.append(", flags ");
        sb.append(this.getFlags());
        return sb.toString();
    }

    public int getPayloadSize() {
        return this.dclass;
    }

    public int getExtendedRcode() {
        return (int)(this.ttl >>> 24);
    }

    public int getVersion() {
        return (int)(this.ttl >>> 16 & 0xFFL);
    }

    public int getFlags() {
        return (int)(this.ttl & 0xFFFFL);
    }

    void rrToWire(DNSOutput out, Compression c2, boolean canonical) {
        if (this.options == null) {
            return;
        }
        Iterator it = this.options.iterator();
        while (it.hasNext()) {
            EDNSOption option = (EDNSOption)it.next();
            option.toWire(out);
        }
    }

    public List getOptions() {
        if (this.options == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.options);
    }

    public List getOptions(int code) {
        if (this.options == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EDNSOption> list = Collections.EMPTY_LIST;
        Iterator it = this.options.iterator();
        while (it.hasNext()) {
            EDNSOption opt = (EDNSOption)it.next();
            if (opt.getCode() != code) continue;
            if (list == Collections.EMPTY_LIST) {
                list = new ArrayList<EDNSOption>();
            }
            list.add(opt);
        }
        return list;
    }

    public boolean equals(Object arg) {
        return super.equals(arg) && this.ttl == ((OPTRecord)arg).ttl;
    }
}

