/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.security.PrivateKey;
import java.util.Date;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGRecord;

public class SIG0 {
    private static final short VALIDITY = 300;

    private SIG0() {
    }

    public static void signMessage(Message message, KEYRecord key, PrivateKey privkey, SIGRecord previous) throws DNSSEC.DNSSECException {
        int validity = Options.intValue("sig0validity");
        if (validity < 0) {
            validity = 300;
        }
        long now = System.currentTimeMillis();
        Date timeSigned = new Date(now);
        Date timeExpires = new Date(now + (long)(validity * 1000));
        SIGRecord sig = DNSSEC.signMessage(message, previous, key, privkey, timeSigned, timeExpires);
        message.addRecord(sig, 3);
    }

    public static void verifyMessage(Message message, byte[] b2, KEYRecord key, SIGRecord previous) throws DNSSEC.DNSSECException {
        SIGRecord sig = null;
        Record[] additional = message.getSectionArray(3);
        for (int i2 = 0; i2 < additional.length; ++i2) {
            if (additional[i2].getType() != 24 || ((SIGRecord)additional[i2]).getTypeCovered() != 0) continue;
            sig = (SIGRecord)additional[i2];
            break;
        }
        DNSSEC.verifyMessage(message, b2, sig, previous, key);
    }
}

