/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.InvalidTTLException;

public final class TTL {
    public static final long MAX_VALUE = Integer.MAX_VALUE;

    private TTL() {
    }

    static void check(long i2) {
        if (i2 < 0L || i2 > Integer.MAX_VALUE) {
            throw new InvalidTTLException(i2);
        }
    }

    public static long parse(String s, boolean clamp) {
        if (s == null || s.length() == 0 || !Character.isDigit(s.charAt(0))) {
            throw new NumberFormatException();
        }
        long value = 0L;
        long ttl = 0L;
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c2 = s.charAt(i2);
            long oldvalue = value;
            if (Character.isDigit(c2)) {
                if ((value = value * 10L + (long)Character.getNumericValue(c2)) >= oldvalue) continue;
                throw new NumberFormatException();
            }
            switch (Character.toUpperCase(c2)) {
                case 'W': {
                    value *= 7L;
                }
                case 'D': {
                    value *= 24L;
                }
                case 'H': {
                    value *= 60L;
                }
                case 'M': {
                    value *= 60L;
                }
                case 'S': {
                    break;
                }
                default: {
                    throw new NumberFormatException();
                }
            }
            value = 0L;
            if ((ttl += value) <= 0xFFFFFFFFL) continue;
            throw new NumberFormatException();
        }
        if (ttl == 0L) {
            ttl = value;
        }
        if (ttl > 0xFFFFFFFFL) {
            throw new NumberFormatException();
        }
        if (ttl > Integer.MAX_VALUE && clamp) {
            ttl = Integer.MAX_VALUE;
        }
        return ttl;
    }

    public static long parseTTL(String s) {
        return TTL.parse(s, true);
    }

    public static String format(long ttl) {
        TTL.check(ttl);
        StringBuffer sb = new StringBuffer();
        long secs = ttl % 60L;
        long mins = (ttl /= 60L) % 60L;
        long hours = (ttl /= 60L) % 24L;
        long days = (ttl /= 24L) % 7L;
        long weeks = ttl /= 7L;
        if (weeks > 0L) {
            sb.append(weeks + "W");
        }
        if (days > 0L) {
            sb.append(days + "D");
        }
        if (hours > 0L) {
            sb.append(hours + "H");
        }
        if (mins > 0L) {
            sb.append(mins + "M");
        }
        if (secs > 0L || weeks == 0L && days == 0L && hours == 0L && mins == 0L) {
            sb.append(secs + "S");
        }
        return sb.toString();
    }
}

