/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class base32 {
    private String alphabet;
    private boolean padding;
    private boolean lowercase;

    public base32(String alphabet, boolean padding, boolean lowercase) {
        this.alphabet = alphabet;
        this.padding = padding;
        this.lowercase = lowercase;
    }

    private static int blockLenToPadding(int blocklen) {
        switch (blocklen) {
            case 1: {
                return 6;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    private static int paddingToBlockLen(int padlen) {
        switch (padlen) {
            case 6: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 0: {
                return 5;
            }
        }
        return -1;
    }

    public String toString(byte[] b2) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < (b2.length + 4) / 5; ++i2) {
            int j2;
            short[] s = new short[5];
            int[] t = new int[8];
            int blocklen = 5;
            for (int j3 = 0; j3 < 5; ++j3) {
                if (i2 * 5 + j3 < b2.length) {
                    s[j3] = (short)(b2[i2 * 5 + j3] & 0xFF);
                    continue;
                }
                s[j3] = 0;
                --blocklen;
            }
            int padlen = base32.blockLenToPadding(blocklen);
            t[0] = (byte)(s[0] >> 3 & 0x1F);
            t[1] = (byte)((s[0] & 7) << 2 | s[1] >> 6 & 3);
            t[2] = (byte)(s[1] >> 1 & 0x1F);
            t[3] = (byte)((s[1] & 1) << 4 | s[2] >> 4 & 0xF);
            t[4] = (byte)((s[2] & 0xF) << 1 | s[3] >> 7 & 1);
            t[5] = (byte)(s[3] >> 2 & 0x1F);
            t[6] = (byte)((s[3] & 3) << 3 | s[4] >> 5 & 7);
            t[7] = (byte)(s[4] & 0x1F);
            for (j2 = 0; j2 < t.length - padlen; ++j2) {
                char c2 = this.alphabet.charAt(t[j2]);
                if (this.lowercase) {
                    c2 = Character.toLowerCase(c2);
                }
                os.write(c2);
            }
            if (!this.padding) continue;
            for (j2 = t.length - padlen; j2 < t.length; ++j2) {
                os.write(61);
            }
        }
        return new String(os.toByteArray());
    }

    public byte[] fromString(String str) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        byte[] raw = str.getBytes();
        for (int i2 = 0; i2 < raw.length; ++i2) {
            char c2 = (char)raw[i2];
            if (Character.isWhitespace(c2)) continue;
            c2 = Character.toUpperCase(c2);
            bs.write((byte)c2);
        }
        if (this.padding) {
            if (bs.size() % 8 != 0) {
                return null;
            }
        } else {
            while (bs.size() % 8 != 0) {
                bs.write(61);
            }
        }
        byte[] in = bs.toByteArray();
        bs.reset();
        DataOutputStream ds = new DataOutputStream(bs);
        for (int i3 = 0; i3 < in.length / 8; ++i3) {
            char c3;
            short[] s = new short[8];
            int[] t = new int[5];
            int padlen = 8;
            for (int j2 = 0; j2 < 8 && (c3 = (char)in[i3 * 8 + j2]) != '='; ++j2) {
                s[j2] = (short)this.alphabet.indexOf(in[i3 * 8 + j2]);
                if (s[j2] < 0) {
                    return null;
                }
                --padlen;
            }
            int blocklen = base32.paddingToBlockLen(padlen);
            if (blocklen < 0) {
                return null;
            }
            t[0] = s[0] << 3 | s[1] >> 2;
            t[1] = (s[1] & 3) << 6 | s[2] << 1 | s[3] >> 4;
            t[2] = (s[3] & 0xF) << 4 | s[4] >> 1 & 0xF;
            t[3] = s[4] << 7 | s[5] << 2 | s[6] >> 3;
            t[4] = (s[6] & 7) << 5 | s[7];
            try {
                for (int j3 = 0; j3 < blocklen; ++j3) {
                    ds.writeByte((byte)(t[j3] & 0xFF));
                }
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bs.toByteArray();
    }

    public static class Alphabet {
        public static final String BASE32 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567=";
        public static final String BASE32HEX = "0123456789ABCDEFGHIJKLMNOPQRSTUV=";

        private Alphabet() {
        }
    }
}

