/*
 * Decompiled with CFR 0.152.
 */
package smc.ext;

import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import java.util.Timer;
import java.util.TimerTask;

public class BladeKVMSwitch {
    IPMICMMOEMCommand ipmiCMMOEMCommand = null;
    IPMIGlobalCommand ipmiGlobalCommand = null;
    ISessionController sessionController = null;
    IPMIInterfaceConfig config;
    String bladeSize;
    Timer timer;

    public BladeKVMSwitch() {
    }

    public BladeKVMSwitch(String ip, String id, String password) {
        this.init(ip, id, password);
    }

    public void init(String ip, String id, String password) {
        this.config = new IPMIInterfaceConfig();
        this.config.setIp(ip);
        this.config.setUserName(id);
        this.config.setPassword(password);
        this.createSession();
    }

    private void createSession() {
        this.ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        this.ipmiGlobalCommand = new IPMIGlobalCommand(null);
        try {
            this.sessionController = SessionControllerFactory.createSessionControllerEx(this.config, this.ipmiCMMOEMCommand);
            this.ipmiGlobalCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            this.keepSession(true);
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
    }

    private void keepSession(boolean flag) {
        if (flag) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    BladeKVMSwitch.this.ipmiGlobalCommand.getDeviceIDCommand();
                }
            };
            this.timer = new Timer();
            this.timer.schedule(timerTask, 0L, 5000L);
        } else if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void closeConnection() {
        this.keepSession(false);
        if (this.sessionController != null) {
            this.sessionController.closeSession();
        }
    }

    public boolean isBladePresent(int index) {
        --index;
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        if (bladeSystem != null) {
            if (index >= bladeSystem.getBlades().length) {
                return false;
            }
            if (bladeSystem.getBlades()[index].getPresent() != 0) {
                return true;
            }
        }
        return false;
    }

    public BladeSystemEntity getBladeSystemEntity() {
        if (this.ipmiCMMOEMCommand == null) {
            return null;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.setIfCheckOnlyOneTime(true);
        bladeSystem.setUseExistConnection(true);
        bladeSystem.setIpmiCMMOEMCommand(this.ipmiCMMOEMCommand);
        bladeSystem.getData();
        if (bladeSystem.isLoginSuccessful) {
            return bladeSystem;
        }
        return null;
    }

    public int getBladeSize() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid != null && IPMIMessagingCommand.isCMMGUID(guid)) {
            byte bladeSize = guid[8];
            byte cmmModuleSize = guid[9];
            byte powerSupplySize = guid[10];
            byte infiniBandSize = guid[11];
            byte gigabitSwitchSize = guid[12];
            return bladeSize;
        }
        return 0;
    }

    public CurrentAndNextKVM getCurrentAndNextKVM() throws Exception {
        BladeEntity blade;
        int i2;
        CurrentAndNextKVM c2 = new CurrentAndNextKVM();
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.setIfCheckOnlyOneTime(true);
        bladeSystem.setUseExistConnection(true);
        bladeSystem.setIpmiCMMOEMCommand(this.ipmiCMMOEMCommand);
        bladeSystem.getData();
        for (i2 = 0; i2 < bladeSystem.getBlades().length; ++i2) {
            blade = bladeSystem.getBlades()[i2];
            if (blade.getPresent() <= 0 || blade.getKvmEnable() != 1) continue;
            c2.current = i2 + 1;
            break;
        }
        if (c2.current == 0) {
            for (i2 = 0; i2 < bladeSystem.getBlades().length; ++i2) {
                blade = bladeSystem.getBlades()[i2];
                if (blade.getPresent() <= 0) continue;
                c2.current = i2 + 1;
                c2.next = i2 + 1;
                c2.previous = i2 + 1;
                return c2;
            }
            throw new Exception("error. no Blade presents");
        }
        int index = c2.current - 1;
        do {
            if (++index == 10) {
                index = 0;
            }
            if ((blade = bladeSystem.getBlades()[index]).getPresent() <= 0) continue;
            c2.next = index + 1;
            break;
        } while (index != c2.current - 1);
        index = c2.current - 1;
        do {
            if (--index < 0) {
                index = bladeSystem.getBlades().length - 1;
            }
            if ((blade = bladeSystem.getBlades()[index]).getPresent() <= 0) continue;
            c2.previous = index + 1;
            break;
        } while (index != c2.current - 1);
        return c2;
    }

    public void requestKVM(int index) throws Exception {
        this.ipmiCMMOEMCommand.requestKVM((byte)index);
    }

    public int switchToLeft() throws Exception {
        CurrentAndNextKVM c2 = this.getCurrentAndNextKVM();
        int bladeSize = this.getBladeSize();
        if (c2 == null) {
            throw new Exception("error");
        }
        this.requestKVM(c2.previous);
        return c2.previous;
    }

    public int switchToRight() throws Exception {
        CurrentAndNextKVM c2 = this.getCurrentAndNextKVM();
        int bladeSize = this.getBladeSize();
        if (c2 == null) {
            throw new Exception("error");
        }
        this.requestKVM(c2.next);
        return c2.next;
    }

    public class CurrentAndNextKVM {
        public int current;
        public int next;
        public int previous;
    }
}

