/*
 * Decompiled with CFR 0.152.
 */
package smc.ext;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Timer;
import java.util.TimerTask;
import smc.ext.OSDMessageManager;

public class OSDMessage {
    OSDMessageManager osdManager;
    public Font font;
    public Color color;
    public String message;
    public int timeout;
    public int x;
    public int y;
    Timer osdMessageOnTimer;

    public OSDMessage() {
        this("default");
    }

    public OSDMessage(String message) {
        this(new Font("Arial", 1, 40), Color.green, 5, 25, 20, message);
    }

    public OSDMessage(String message, int fontSize) {
        this(message);
        this.font = new Font("Arial", 1, fontSize);
    }

    public OSDMessage(String message, int x, int y, int fontSize) {
        this(message, fontSize);
        this.x = x;
        this.y = y;
    }

    public OSDMessage(String message, int x, int y) {
        this(message);
        this.x = x;
        this.y = y;
    }

    public OSDMessage(String message, int x, int y, Color color) {
        this(message);
        this.x = x;
        this.y = y;
        this.color = color;
    }

    public OSDMessage(Font font, Color color, int timeout, int x, int y, String message) {
        this.font = font;
        this.color = color;
        this.timeout = timeout;
        this.x = x;
        this.y = y;
        this.message = message;
    }

    public void setOsdManager(OSDMessageManager osdManager) {
        this.osdManager = osdManager;
    }

    public Dimension getDrawDimension(Graphics g2) {
        FontMetrics fm = g2.getFontMetrics(this.font);
        int width = fm.stringWidth(this.message);
        int height = fm.getHeight();
        height += height / 3;
        Dimension d2 = new Dimension(width, height);
        return d2;
    }

    public void drawOSD(Graphics g2, int offsetX, int offsetY) {
        Dimension d2 = this.getDrawDimension(g2);
        Graphics2D g22 = (Graphics2D)g2;
        g22.setFont(this.font);
        g22.setColor(Color.BLACK);
        g22.drawString(this.message, -1 + offsetX, d2.height - d2.height / 3 + offsetY);
        g22.setColor(this.color);
        g22.drawString(this.message, 0 + offsetX, d2.height - d2.height / 3 + offsetY);
    }

    public void drawOSD(Graphics g2) {
        this.drawOSD(g2, 0, 0);
    }

    public void countDown() {
        if (this.osdMessageOnTimer != null) {
            this.osdMessageOnTimer.cancel();
            this.osdMessageOnTimer = null;
        }
        this.osdMessageOnTimer = new Timer();
        this.osdMessageOnTimer.schedule((TimerTask)new RemoveMeTimerTask(this), this.timeout * 1000);
    }

    public void clearTimer() {
        if (this.osdMessageOnTimer != null) {
            this.osdMessageOnTimer.cancel();
            this.osdMessageOnTimer = null;
        }
    }

    class RemoveMeTimerTask
    extends TimerTask {
        OSDMessage osdMessage;

        public RemoveMeTimerTask(OSDMessage osdMessage) {
            this.osdMessage = osdMessage;
        }

        @Override
        public void run() {
            this.osdMessage.osdManager.removeOSDMessage(this.osdMessage);
        }
    }
}

