/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.vstorage;

import com.supermicro.ipmi.text.VMWACommand;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import tw.com.aten.bean.ConnInfo;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.bean.PlatformInfo;
import tw.com.aten.bean.UserInfo;
import tw.com.aten.ikvm.jni.RMConnection;
import tw.com.aten.vstorage.bean.VSBtnEventInfo;

public class VirtualStorage {
    private static final long serialVersionUID = 1L;
    private VirtualStorage pthis = null;
    private InfoRepository infoRepository = null;
    private String id = null;
    private String password = null;
    private String ipaddr = null;
    private static String vm_java_version = "1.2 r2";
    private static String vm_lib_version = "1.1 r1";
    private int port = 0;
    private LinkedList<VSBtnEventInfo> vsbtnEventPool;
    private BlockingQueue<Object> eventQueue;
    private PlatformInfo platformInfo;
    private int platformVer;
    private int org_lang_idx = 255;
    int companyId;
    int boardId;
    private static final int EVENT_CAPACITY = 200;
    private static final int DEVICE1 = 1;
    private static final int DEVICE2 = 2;
    private static final int DEVICE3 = 3;
    private static final int UPLOAD = 4;
    private static final int REFRESH = 1;
    private static final int PLUGIN = 2;
    private static final int PLUGOUT = 3;
    private static final int OPIMGFILE = 4;
    private static final int UPLOADIMG = 5;
    private static final int PLUGOUTIMG = 6;
    private static final int CB_SELECT = 7;
    private static final int GUI_OBJ_DEV1 = 0;
    private static final int GUI_OBJ_DEV2 = 0x20000000;
    private static final int GUI_OBJ_DEV3 = 0x40000000;
    private static final int GUI_OBJ_PLUGIN = 1;
    private static final int GUI_OBJ_PLUGOUT = 2;
    private static final int GUI_OBJ_REFRESH = 4;
    private static final int GUI_OBJ_OPEN_DEV_FILE_MF_EN = 512;
    private static final int GUI_OBJ_OK = 8;
    private static final int GUI_OBJ_CB = 16;
    private static final int GUI_OBJ_FILE_PATH_FIELD = 32;
    private static final int GUI_OBJ_OPEN_DEV_FILE = 64;
    private static final int GUI_OBJ_SET_CB_IDX = 128;
    private static final int GUI_OBJ_DEV_NAME = 256;
    private static final int MASK_CB_IDX = 528482304;
    private static final String newline = "\n";
    private JPanel jvsuiContentPane = null;
    private JTabbedPane jAllDevTPane = null;
    private JPanel jDevHealthPanel = null;
    private JScrollPane jMsgScreenScrollPane = null;
    public JTextArea jMsgScreenTextArea = null;
    private String s_gui_mt = "Plug In";
    private String s_gui_unmt = "Plug Out";
    private String s_gui_refresh = "Refresh";
    private String s_gui_ok = "OK";
    private String s_gui_name_dev1 = "Device 1";
    private String s_gui_name_dev2 = "Device 2";
    private String s_gui_name_dev3 = "Device 3";
    private int MountFolder_en = 0;
    private JButton jBtOpFileDev1 = null;
    private JButton jBtRefreshDev1 = null;
    private JButton jBtPlugInDev1 = null;
    private JButton jBtPlugOutDev1 = null;
    private JButton jBtOKDev1 = null;
    private JComboBox jCBDev1 = null;
    private JLabel jLabDevHealthHeaderDev1 = null;
    private JLabel jLabPicDev1 = null;
    private JLabel jLabLDTSelHeaderDev1 = null;
    private JLabel jLabFileHeaderDev1 = null;
    private JPanel jDevPanelDev1 = null;
    private JPanel jSetPanelDev1 = null;
    private JTextField jTFDev1 = null;
    private JButton jBtOpFileDev2 = null;
    private JButton jBtRefreshDev2 = null;
    private JButton jBtPlugInDev2 = null;
    private JButton jBtPlugOutDev2 = null;
    private JButton jBtOKDev2 = null;
    private JComboBox jCBDev2 = null;
    private JLabel jLabDevHealthHeaderDev2 = null;
    private JLabel jLabPicDev2 = null;
    private JLabel jLabLDTSelHeaderDev2 = null;
    private JLabel jLabFileHeaderDev2 = null;
    private JPanel jDevPanelDev2 = null;
    private JPanel jSetPanelDev2 = null;
    private JTextField jTFDev2 = null;
    private JButton jBtOpFileDev3 = null;
    private JButton jBtRefreshDev3 = null;
    private JButton jBtPlugInDev3 = null;
    private JButton jBtPlugOutDev3 = null;
    private JButton jBtOKDev3 = null;
    private JComboBox jCBDev3 = null;
    private JLabel jLabDevHealthHeaderDev3 = null;
    private JLabel jLabPicDev3 = null;
    private JLabel jLabLDTSelHeaderDev3 = null;
    private JLabel jLabFileHeaderDev3 = null;
    private JPanel jDevPanelDev3 = null;
    private JPanel jSetPanelDev3 = null;
    private JTextField jTFDev3 = null;
    private JButton jBtOpFileUpload = null;
    private JButton jBtIMAUpload = null;
    private JButton jBtPlugOutUpload = null;
    private JButton jBtOKUpload = null;
    private JLabel jLabFileHeaderUpload = null;
    private JPanel jUploadPanel = null;
    private JPanel jSetUploadPanel = null;
    private JTextField jTFUpload = null;
    private Thread dev1thread;
    private Thread dev2thread;
    private Thread dev3thread;
    private Thread eventThread;
    private Thread showmsgThread;
    private Thread ChangeGUIObjectThread;
    private Thread CheckDevExistThread;
    String[] VMStatusString;
    String[] VMUIString;
    String lastString;
    String isoFilename;
    StringBuffer statusLog = new StringBuffer();
    public String[] dev1Array = new String[256];
    public String[] dev2Array = new String[256];
    public String[] dev3Array = new String[256];
    int dev1Count;
    int dev2Count;
    int dev1MountIndex = 0;
    int dev2MountIndex = 0;
    private static final String HMAC_SHA1 = "HmacSHA1";

    public native void RefreshDevCBContents(int var1, int var2, String[] var3);

    public native void VUSPlugIn(int var1, String var2, int var3, String var4);

    public native void VUSPlugOut(int var1, int var2);

    public native void ChangeCBSelect(int var1, int var2);

    public native void JThterminate();

    public native void JASWInit(int var1, int var2, int var3);

    public native void JASetUNamePwdIPPort(String var1, String var2, String var3, int var4);

    public native void StartDev1Thread();

    public native void StartDev2Thread();

    public native void StartDev3Thread();

    public native void StartShowMsgThread();

    public native void StartChangeGUIObjectThread();

    public native void StartCheckDevExistThread();

    public native void StartGetDevHealthStatusThread();

    public native void ResetLANDisconnect();

    public byte[] GetDataIntegrity(int length, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException {
        String key_str = this.id + this.password;
        byte[] key = key_str.getBytes();
        byte[] myArray = new byte[length];
        System.arraycopy(data, 0, myArray, 0, length);
        SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(signingKey);
        byte[] result = mac.doFinal(myArray);
        return result;
    }

    public void NFFillVMVersion(String vm_lib_ver) {
        vm_lib_version = vm_lib_ver;
    }

    public void NFGetVMCount(int VMCount) {
    }

    public void NFChangeGUIObject(int state) {
    }

    public void NFGetMsgID(int msg_id) {
        int vm_status_idx = msg_id & 0x1FFFFFFF;
        int vm_dev_idx = msg_id & 0xE0000000;
        this.SetLangIdxToVM();
        if (vm_dev_idx == 0) {
            this.lastString = "Device 1 :";
        } else if (vm_dev_idx == 0x20000000) {
            this.lastString = "Device 2 :";
        } else if (vm_dev_idx == 0x40000000) {
            this.lastString = "Device 3 :";
        }
        this.lastString = this.lastString + this.VMStatusString[vm_status_idx] + newline;
        if (VMWACommand.isShowDebugMsg) {
            System.out.println("Debug : " + this.lastString);
        }
        this.statusLog.append(this.lastString);
    }

    public VirtualStorage(InfoRepository infoRepository) {
        this.platformInfo = infoRepository.getPlatformInfo();
        this.id = infoRepository.getUserInfo().getUserName();
        this.password = infoRepository.getUserInfo().getPassword();
        this.ipaddr = infoRepository.getConnInfo().getIp();
        this.platformVer = this.platformInfo.getPlatformVer();
        this.companyId = this.platformInfo.getCompanyId();
        this.boardId = this.platformInfo.getBoardId();
        this.port = infoRepository.getVirtualUsbInfo().getPort();
        this.JASWInit(this.platformVer, this.companyId, this.boardId);
        this.initialize();
        this.pthis = this;
        this.vsbtnEventPool = new LinkedList();
        for (int i2 = 0; i2 < 100; ++i2) {
            this.vsbtnEventPool.add(new VSBtnEventInfo());
        }
        this.eventQueue = new ArrayBlockingQueue<Object>(200, false);
        this.eventThread = new Thread(new EventThread());
        this.eventThread.start();
        this.showmsgThread = new Thread(new ShowMsgThread());
        this.showmsgThread.start();
        this.ChangeGUIObjectThread = new Thread(new C_GUIObjectThreadThread());
        this.ChangeGUIObjectThread.start();
        this.CheckDevExistThread = new Thread(new C_DevExistThread());
        this.CheckDevExistThread.start();
        this.refreshDevList();
        this.dev1thread = new Thread(new Dev1Thread());
        this.dev1thread.start();
        this.dev2thread = new Thread(new Dev2Thread());
        this.dev2thread.start();
        this.dev3thread = new Thread(new Dev3Thread());
        this.dev3thread.start();
        this.SetVSInfo(infoRepository);
    }

    private void refreshDevList() {
        for (int i2 = 0; i2 < this.dev1Array.length; ++i2) {
            this.dev1Array[i2] = null;
            this.dev2Array[i2] = null;
            this.dev3Array[i2] = null;
        }
        this.RefreshDevCBContents(0, 0, this.dev1Array);
        this.RefreshDevCBContents(1, 0, this.dev2Array);
        this.RefreshDevCBContents(2, 0, this.dev3Array);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    public void SetVSInfo(InfoRepository infoRepository) {
        this.infoRepository = infoRepository;
        this.JASetUNamePwdIPPort(this.id, this.password, this.ipaddr, this.port);
    }

    public static String GetVSVersion() {
        return vm_java_version;
    }

    public void ShowVSUI() {
    }

    public void VS_Terminate() {
        this.JThterminate();
    }

    public void VSReset_LANDisconnect() {
        this.ResetLANDisconnect();
    }

    private void initialize() {
    }

    public void SetLangIdxToVM() {
        int langIndex = this.infoRepository.getLangIdx();
        if (this.org_lang_idx != langIndex) {
            this.org_lang_idx = langIndex;
            this.VMStatusString = langIndex != 0 && langIndex != 7 ? this.infoRepository.getVMStatusString() : this.infoRepository.getVMStatusString(langIndex);
        }
    }

    public void SMCIPMITool_API________________________________________________() {
    }

    public String dev1List() {
        int count = 0;
        StringBuffer sb = new StringBuffer();
        this.refreshDevList();
        for (int i2 = 2; i2 < this.dev1Array.length; ++i2) {
            if (this.dev1Array[i2] == null) continue;
            sb.append(i2 + ": [" + this.dev1Array[i2] + "]\n");
            ++count;
        }
        this.dev1Count = count;
        if (count == 0) {
            sb.append("No available device");
        }
        return sb.toString();
    }

    public boolean checkIsDev1IndexValid(int index) {
        this.dev1List();
        boolean flag = true;
        if (index < 2) {
            flag = false;
        }
        if (index >= this.dev1Count + 2) {
            flag = false;
        }
        return flag;
    }

    public String[] getDev1Array() {
        return this.dev1Array;
    }

    public String dev2List() {
        int count = 0;
        StringBuffer sb = new StringBuffer();
        this.refreshDevList();
        for (int i2 = 2; i2 < this.dev2Array.length; ++i2) {
            if (this.dev2Array[i2] == null) continue;
            sb.append(i2 + ": [" + this.dev2Array[i2] + "]\n");
            ++count;
        }
        this.dev2Count = count;
        if (count == 0) {
            sb.append("No available device");
        }
        return sb.toString();
    }

    public String[] getDev2Array() {
        return this.dev2Array;
    }

    public boolean checkIsDev2IndexValid(int index) {
        this.dev2List();
        boolean flag = true;
        if (index < 2) {
            flag = false;
        }
        if (index >= this.dev2Count + 2) {
            flag = false;
        }
        return flag;
    }

    public void dev1Mount(int index) {
        if (VMWACommand.isShowDebugMsg) {
            System.out.println("Debug: clear last string ");
        }
        this.lastString = "";
        this.VUSPlugIn(0, "", index, this.dev1Array[index]);
        int count = 0;
        while (this.lastString.isEmpty() && count++ < 45) {
            if (count == 6) {
                System.out.println("This command will take some time ...");
            }
            if (VMWACommand.isShowDebugMsg) {
                System.out.println("Debug: Wait " + 2 * (count - 1) + " sec");
            }
            this.sleep(2);
        }
        if (this.lastString != null && this.lastString.indexOf("Plug-In") != -1 && this.lastString.indexOf("OK") != -1) {
            this.dev1MountIndex = index;
        } else {
            if (this.lastString.isEmpty()) {
                this.lastString = "Can't get mount response\n";
            }
            this.dev1MountIndex = 0;
        }
    }

    public void dev2CDMount(int index) {
        this.VUSPlugIn(1, "", index, this.dev2Array[index]);
        this.sleep(5);
        this.dev2MountIndex = this.lastString != null && this.lastString.indexOf("Plug-In") != -1 && this.lastString.indexOf("OK") != -1 ? index : 0;
    }

    public void dev2ISOMount(String filename) {
        if (VMWACommand.isShowDebugMsg) {
            System.out.println("Debug: clear last string ");
        }
        this.lastString = "";
        this.VUSPlugIn(1, filename, 1, "ISO File");
        int count = 0;
        while (this.lastString.isEmpty() && count++ < 45) {
            if (count == 6) {
                System.out.println("This command will take some time ...");
            }
            if (VMWACommand.isShowDebugMsg) {
                System.out.println("Debug: Wait " + 2 * (count - 1) + " sec");
            }
            this.sleep(2);
        }
        if (this.lastString != null && this.lastString.indexOf("Plug-In") != -1 && this.lastString.indexOf("OK") != -1) {
            this.dev2MountIndex = 1;
            this.isoFilename = filename;
        } else {
            if (this.lastString.isEmpty()) {
                this.lastString = "Can't get mount response\n";
            }
            if (this.lastString.indexOf("Plug-Out") == -1 || this.lastString.indexOf("OK") != -1) {
                // empty if block
            }
            this.dev2MountIndex = 0;
            this.isoFilename = "";
        }
    }

    public void dev1UnmountTemp() {
        if (VMWACommand.isShowDebugMsg) {
            System.out.println("Debug: clear last string ");
        }
        this.lastString = "";
        if (this.dev1MountIndex == 0) {
            this.lastString = "No Mounted Device\n";
            return;
        }
        this.VUSPlugOut(0, this.dev1MountIndex);
        int count = 0;
        while (this.lastString.isEmpty() && count++ < 15) {
            if (VMWACommand.isShowDebugMsg) {
                System.out.println("Debug: Wait " + 2 * (count - 1) + " sec");
            }
            this.sleep(2);
        }
        if (this.lastString.isEmpty()) {
            this.lastString = "Can't get unmount response\n";
        }
        this.dev1MountIndex = 0;
    }

    public void dev2Unmount() {
        if (VMWACommand.isShowDebugMsg) {
            System.out.println("Debug: clear last string ");
        }
        this.lastString = "";
        if (this.dev2MountIndex == 0) {
            this.lastString = "No Mounted Device\n";
            return;
        }
        this.VUSPlugOut(1, this.dev2MountIndex);
        int count = 0;
        while (this.lastString.isEmpty() && count++ < 15) {
            if (VMWACommand.isShowDebugMsg) {
                System.out.println("Debug: Wait " + 2 * (count - 1) + " sec");
            }
            this.sleep(2);
        }
        if (this.lastString.isEmpty()) {
            this.lastString = "Can't get unmount response\n";
        }
        this.dev2MountIndex = 0;
    }

    public void dev1Unmount() {
        this.lastString = "";
        if (this.dev1MountIndex == 0) {
            this.lastString = "No Mounted Device\n";
            return;
        }
        this.VUSPlugOut(0, this.dev1MountIndex);
        int count = 0;
        while (this.lastString.isEmpty() && count++ < 15) {
            if (VMWACommand.isShowDebugMsg) {
                System.out.println("Debug: Wait " + 2 * (count - 1) + " sec");
            }
            this.sleep(2);
        }
        if (this.lastString.isEmpty()) {
            this.lastString = "Can't get unmount response\n";
        }
        this.dev1MountIndex = 0;
    }

    public void dev2UnmountOriginal() {
        this.VUSPlugOut(1, this.dev2MountIndex);
        this.dev2MountIndex = 0;
    }

    public String lastMessage() {
        return this.lastString;
    }

    public String getLog() {
        return this.statusLog.toString();
    }

    public String mountStatus() {
        StringBuffer sb = new StringBuffer();
        if (this.dev1MountIndex != 0) {
            sb.append("Device 1: " + this.dev1Array[this.dev1MountIndex]);
        } else {
            sb.append("Device 1: None");
        }
        sb.append(newline);
        if (this.dev2MountIndex != 0) {
            sb.append("Device 2: " + this.dev2Array[this.dev2MountIndex]);
            if (this.dev2MountIndex == 1) {
                sb.append(" [" + this.isoFilename + "]");
            }
        } else {
            sb.append("Device 2: None");
        }
        sb.append(newline);
        return sb.toString();
    }

    public int getDev1MountIndex() {
        return this.dev1MountIndex;
    }

    public int getDev2MountIndex() {
        return this.dev2MountIndex;
    }

    public String mountStatus(int device) {
        StringBuffer sb = new StringBuffer();
        switch (device) {
            case 1: {
                if (this.dev1MountIndex != 0) {
                    sb.append("Device 1: " + this.dev1Array[this.dev1MountIndex]);
                    break;
                }
                sb.append("Device 1: None");
                break;
            }
            case 2: {
                if (this.dev2MountIndex != 0) {
                    sb.append("Device 2: " + this.dev2Array[this.dev2MountIndex]);
                    if (this.dev2MountIndex != 1) break;
                    sb.append(" [" + this.isoFilename + "]");
                    break;
                }
                sb.append("Device 2: None");
            }
        }
        return sb.toString();
    }

    public void sleep(int second) {
        try {
            Thread.sleep(second * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void loadLibrary() {
        Locale locale = new Locale("en", "us");
        Locale.setDefault(locale);
        String osArch = System.getProperty("os.arch");
        try {
            if (osArch.indexOf("64") != -1) {
                System.loadLibrary("iKVM".concat("64"));
                System.loadLibrary("SharedLibrary".concat("64"));
            } else {
                System.loadLibrary("iKVM".concat("32"));
                System.loadLibrary("SharedLibrary".concat("32"));
            }
            RMConnection.init(ConnInfo.class, UserInfo.class);
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    public static void loadLibrary(int stunnelVer) {
        switch (stunnelVer) {
            case 0: 
            case 5: {
                stunnelVer = 0;
                break;
            }
            case 9: {
                stunnelVer = 0;
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                stunnelVer = 11;
                break;
            }
            default: {
                stunnelVer = 11;
            }
        }
        Locale locale = new Locale("en", "us");
        Locale.setDefault(locale);
        String osArch = System.getProperty("os.arch");
        try {
            if (osArch.indexOf("64") != -1) {
                if (stunnelVer >= 11) {
                    System.loadLibrary("iKVM_v" + stunnelVer + "_".concat("64"));
                    System.loadLibrary("SharedLibrary_v" + stunnelVer + "_".concat("64"));
                } else {
                    System.loadLibrary("iKVM".concat("64"));
                    System.loadLibrary("SharedLibrary".concat("64"));
                }
            } else if (stunnelVer >= 11) {
                System.loadLibrary("iKVM_v" + stunnelVer + "_".concat("32"));
                System.loadLibrary("SharedLibrary_v" + stunnelVer + "_".concat("32"));
            } else {
                System.loadLibrary("iKVM".concat("32"));
                System.loadLibrary("SharedLibrary".concat("32"));
            }
            RMConnection.init(ConnInfo.class, UserInfo.class);
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    public static boolean loadLibraryAndValidateUser(int stunnelVer, InfoRepository infoRepository) {
        switch (stunnelVer) {
            case 0: 
            case 5: {
                stunnelVer = 0;
                break;
            }
            case 9: {
                stunnelVer = 0;
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                stunnelVer = 11;
                break;
            }
            default: {
                stunnelVer = 0;
            }
        }
        Locale locale = new Locale("en", "us");
        Locale.setDefault(locale);
        String osArch = System.getProperty("os.arch");
        try {
            if (osArch.indexOf("64") != -1) {
                if (stunnelVer >= 11) {
                    System.loadLibrary("iKVM_v" + stunnelVer + "_".concat("64"));
                    System.loadLibrary("SharedLibrary_v" + stunnelVer + "_".concat("64"));
                } else {
                    System.loadLibrary("iKVM".concat("64"));
                    System.loadLibrary("SharedLibrary".concat("64"));
                }
            } else if (stunnelVer >= 11) {
                System.loadLibrary("iKVM_v" + stunnelVer + "_".concat("32"));
                System.loadLibrary("SharedLibrary_v" + stunnelVer + "_".concat("32"));
            } else {
                System.loadLibrary("iKVM".concat("32"));
                System.loadLibrary("SharedLibrary".concat("32"));
            }
            RMConnection.init(ConnInfo.class, UserInfo.class);
            int retry = 0;
            int maxRetry = 10;
            while (!RMConnection.keepActive(infoRepository.getConnInfo())) {
                if (retry == maxRetry) {
                    return false;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                ++retry;
            }
            return RMConnection.checkValidUser(infoRepository.getUserInfo());
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        VirtualStorage.loadLibrary();
        InfoRepository infoRepository = InfoRepository.createInfoRepository("2.168.12.151", "root", "superuser");
        VirtualStorage vs = new VirtualStorage(infoRepository);
        System.out.println(vs.dev1List());
        System.out.println(vs.dev2List());
        System.out.println("Mount winpe3 ISo file");
        vs.VUSPlugIn(1, "d:\\ISO\\winpe3.iso", 1, "ISO File");
        System.out.println("Mount USB HD");
        vs.VUSPlugIn(0, "", 3, "G: USB HD");
        System.out.println("Wait 15 seconds");
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        vs.VUSPlugOut(1, 1);
        System.out.println("Mount slax-6.0.9.iso ISo file");
        vs.VUSPlugIn(1, "d:\\ISO\\slax-6.0.9.iso", 1, "ISO File");
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class EventThread
    implements Runnable {
        private EventThread() {
        }

        @Override
        public void run() {
        }
    }

    private class GetDevHealthStatusThread
    implements Runnable {
        private GetDevHealthStatusThread() {
        }

        @Override
        public void run() {
            while (true) {
                VirtualStorage.this.StartGetDevHealthStatusThread();
            }
        }
    }

    private class C_DevExistThread
    implements Runnable {
        private C_DevExistThread() {
        }

        @Override
        public void run() {
            VirtualStorage.this.StartCheckDevExistThread();
        }
    }

    private class C_GUIObjectThreadThread
    implements Runnable {
        private C_GUIObjectThreadThread() {
        }

        @Override
        public void run() {
            while (true) {
                VirtualStorage.this.StartChangeGUIObjectThread();
            }
        }
    }

    private class ShowMsgThread
    implements Runnable {
        private ShowMsgThread() {
        }

        @Override
        public void run() {
            while (true) {
                VirtualStorage.this.StartShowMsgThread();
            }
        }
    }

    private class Dev3Thread
    implements Runnable {
        private Dev3Thread() {
        }

        @Override
        public void run() {
            VirtualStorage.this.StartDev3Thread();
        }
    }

    private class Dev2Thread
    implements Runnable {
        private Dev2Thread() {
        }

        @Override
        public void run() {
            VirtualStorage.this.StartDev2Thread();
        }
    }

    private class Dev1Thread
    implements Runnable {
        private Dev1Thread() {
        }

        @Override
        public void run() {
            VirtualStorage.this.StartDev1Thread();
        }
    }
}

